/*
 * Decompiled with CFR 0.152.
 */
package com.yandex.android.appmetrica.plugin.configurator;

import com.android.build.gradle.api.ApplicationVariant;
import com.android.builder.model.BuildType;
import com.yandex.android.appmetrica.Log;
import com.yandex.android.appmetrica.plugin.BuildUuidHelper;
import com.yandex.android.appmetrica.plugin.UploadTask;
import com.yandex.android.appmetrica.plugin.configurator.Configurator;
import com.yandex.android.appmetrica.plugin.extension.AppMetricaExtension;
import com.yandex.android.appmetrica.plugin.gradle.AGPHelper;
import com.yandex.android.appmetrica.plugin.provider.BuildInfoFileProvider;
import com.yandex.android.appmetrica.plugin.provider.FileProvider;
import com.yandex.android.appmetrica.plugin.provider.MappingFileProvider;
import com.yandex.android.appmetrica.plugin.provider.ZipFileProvider;
import java.io.File;
import java.nio.file.Paths;
import java.util.List;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.tasks.TaskContainer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/yandex/android/appmetrica/plugin/configurator/CommonConfigurator;", "Lcom/yandex/android/appmetrica/plugin/configurator/Configurator;", "project", "Lorg/gradle/api/Project;", "extension", "Lcom/yandex/android/appmetrica/plugin/extension/AppMetricaExtension;", "agpHelper", "Lcom/yandex/android/appmetrica/plugin/gradle/AGPHelper;", "(Lorg/gradle/api/Project;Lcom/yandex/android/appmetrica/plugin/extension/AppMetricaExtension;Lcom/yandex/android/appmetrica/plugin/gradle/AGPHelper;)V", "configure", "", "variant", "Lcom/android/build/gradle/api/ApplicationVariant;", "appmetrica-build-plugin"})
public final class CommonConfigurator
extends Configurator {
    private final AGPHelper agpHelper;

    @Override
    public void configure(@NotNull ApplicationVariant variant) {
        Intrinsics.checkParameterIsNotNull(variant, "variant");
        String buildId = BuildUuidHelper.INSTANCE.getBuildUuid(variant);
        Log.INSTANCE.info("Configuring " + variant.getName() + ":\n" + "\tbuild id = " + buildId + '\n' + "\toffline = " + this.getExtension().getOffline().invoke(variant) + '\n' + "\tndk.enable = " + this.getExtension().getNdk().getEnable().invoke(variant));
        variant.resValue("string", "com.yandex.android.appmetrica.build_id", buildId);
        variant.resValue("bool", "com.yandex.android.appmetrica.is_offline", String.valueOf(this.getExtension().getOffline().invoke(variant)));
        variant.resValue("bool", "com.yandex.android.appmetrica.ndk.enable", String.valueOf(this.getExtension().getNdk().getEnable().invoke(variant)));
        TaskContainer taskContainer = this.getProject().getTasks();
        StringBuilder stringBuilder = new StringBuilder().append("upload");
        String string = variant.getName();
        Intrinsics.checkExpressionValueIsNotNull(string, "variant.name");
        UploadTask uploadTask2 = (UploadTask)taskContainer.create(stringBuilder.append(StringsKt.capitalize(string)).append("Mapping").toString(), UploadTask.class, (Action)new Action<UploadTask>(this, variant, buildId){
            final /* synthetic */ CommonConfigurator this$0;
            final /* synthetic */ ApplicationVariant $variant;
            final /* synthetic */ String $buildId;

            public final void execute(UploadTask task) {
                task.setUploadUrl("https://api.appmetrica.yandex.ru/management/v1/application/crash/proguard/upload");
                task.setPostApiKey(this.this$0.getExtension().getPostApiKey().invoke(this.$variant));
                task.setOffline(this.this$0.getExtension().getOffline().invoke(this.$variant));
                List<FileProvider> list = CollectionsKt.listOf(new BuildInfoFileProvider(this.this$0.getProject(), this.$buildId, this.$variant), new MappingFileProvider(this.$variant, this.this$0.getExtension(), CommonConfigurator.access$getAgpHelper$p(this.this$0)));
                File file = this.this$0.getProject().getBuildDir();
                Intrinsics.checkExpressionValueIsNotNull(file, "project.buildDir");
                String string = file.getAbsolutePath();
                String[] stringArray = new String[3];
                stringArray[0] = "mappings";
                stringArray[1] = this.$variant.getFlavorName();
                BuildType buildType = this.$variant.getBuildType();
                Intrinsics.checkExpressionValueIsNotNull(buildType, "variant.buildType");
                stringArray[2] = buildType.getName();
                File file2 = Paths.get(string, stringArray).toFile();
                Intrinsics.checkExpressionValueIsNotNull(file2, "Paths.get(project.buildD\u2026.buildType.name).toFile()");
                task.setFileProvider(new ZipFileProvider(list, file2));
                task.setEnableAnalytics(this.this$0.getExtension().getEnableAnalytics());
                task.setParamsForAnalytics(MapsKt.plus(MapsKt.mapOf(TuplesKt.to("task_type", "upload_mapping")), this.this$0.getParamsForAnalytics(this.$variant)));
            }
            {
                this.this$0 = commonConfigurator;
                this.$variant = applicationVariant;
                this.$buildId = string;
            }
        });
        this.getProject().afterEvaluate((Action)new Action<Project>(this, variant, uploadTask2){
            final /* synthetic */ CommonConfigurator this$0;
            final /* synthetic */ ApplicationVariant $variant;
            final /* synthetic */ UploadTask $uploadTask;

            public final void execute(Project it) {
                block1: {
                    Task task = CommonConfigurator.access$getAgpHelper$p(this.this$0).getAssemble(this.$variant);
                    if (task != null) {
                        task.finalizedBy(new Object[]{this.$uploadTask});
                    }
                    Task task2 = CommonConfigurator.access$getAgpHelper$p(this.this$0).getAssembleBundle(this.this$0.getProject(), this.$variant);
                    if (task2 == null) break block1;
                    task2.finalizedBy(new Object[]{this.$uploadTask});
                }
            }
            {
                this.this$0 = commonConfigurator;
                this.$variant = applicationVariant;
                this.$uploadTask = uploadTask2;
            }
        });
    }

    public CommonConfigurator(@NotNull Project project, @NotNull AppMetricaExtension extension, @NotNull AGPHelper agpHelper) {
        Intrinsics.checkParameterIsNotNull(project, "project");
        Intrinsics.checkParameterIsNotNull(extension, "extension");
        Intrinsics.checkParameterIsNotNull(agpHelper, "agpHelper");
        super(project, extension);
        this.agpHelper = agpHelper;
    }

    public static final /* synthetic */ AGPHelper access$getAgpHelper$p(CommonConfigurator $this) {
        return $this.agpHelper;
    }
}

