/*
 * Decompiled with CFR 0.152.
 */
package com.yandex.browser.rtm;

import com.yandex.browser.rtm.Assert;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0007J\u0010\u0010\n\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\u000b"}, d2={"Lcom/yandex/browser/rtm/StackTraceUtils;", "", "()V", "getShrunkStackTrace", "", "throwable", "", "depth", "", "causeDepth", "getStackTrace", "lib-redir-log"})
public final class StackTraceUtils {
    @NotNull
    public static final StackTraceUtils INSTANCE;

    @JvmStatic
    @NotNull
    public static final String getShrunkStackTrace(@NotNull Throwable throwable) {
        Intrinsics.checkNotNullParameter(throwable, "throwable");
        return StackTraceUtils.getShrunkStackTrace(throwable, 1);
    }

    @JvmStatic
    @NotNull
    public static final String getShrunkStackTrace(@NotNull Throwable throwable, int depth) {
        Intrinsics.checkNotNullParameter(throwable, "throwable");
        return StackTraceUtils.getShrunkStackTrace(throwable, depth, 4);
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final String getShrunkStackTrace(@NotNull Throwable throwable, int depth, int causeDepth) {
        Intrinsics.checkNotNullParameter(throwable, "throwable");
        if (-1 == depth) {
            return StackTraceUtils.getStackTrace(throwable);
        }
        int depthLeft = depth;
        Writer writer = new StringWriter();
        PrintWriter printWriter = new PrintWriter(writer);
        Throwable cause = throwable;
        int nestedCausesCount = -1;
        while (cause != null) {
            cause = cause.getCause();
            ++nestedCausesCount;
        }
        if (nestedCausesCount < depthLeft) {
            depthLeft = nestedCausesCount;
        }
        for (cause = throwable; cause != null && depthLeft > 0; cause = cause.getCause(), --depthLeft) {
            printWriter.println(cause.toString());
            StackTraceElement[] elements = cause.getStackTrace();
            int n = 0;
            int n2 = Math.min(elements.length, causeDepth);
            while (n < n2) {
                void i;
                printWriter.println("\tat " + elements[i]);
                ++i;
            }
            printWriter.print("Caused by: ");
        }
        int skipped = 0;
        while (true) {
            Throwable throwable2 = cause;
            if ((throwable2 != null ? throwable2.getCause() : null) == null) break;
            ++skipped;
            cause = cause.getCause();
        }
        if (skipped != 0) {
            StringCompanionObject i = StringCompanionObject.INSTANCE;
            Locale locale = Locale.US;
            String string = "... %d intermediate causes were omitted.";
            Object[] objectArray = new Object[]{skipped};
            boolean bl = false;
            String string2 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue(string2, "java.lang.String.format(locale, format, *args)");
            printWriter.println(string2);
        }
        if (cause != null) {
            Assert.assertEquals("Expected null cause", null, cause.getCause());
            if (throwable != cause) {
                printWriter.print("Caused by: ");
            }
            cause.printStackTrace(printWriter);
        }
        String stackTrace = writer.toString();
        printWriter.close();
        return stackTrace;
    }

    @JvmStatic
    @NotNull
    public static final String getStackTrace(@NotNull Throwable throwable) {
        Intrinsics.checkNotNullParameter(throwable, "throwable");
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        throwable.printStackTrace(printWriter);
        String string = stringWriter.toString();
        Intrinsics.checkNotNullExpressionValue(string, "stringWriter.toString()");
        return string;
    }

    private StackTraceUtils() {
    }

    static {
        StackTraceUtils stackTraceUtils;
        INSTANCE = stackTraceUtils = new StackTraceUtils();
    }
}

