/*
 * Decompiled with CFR 0.152.
 */
package com.yandex.metrica.push.firebase;

import android.content.Context;
import android.os.Bundle;
import androidx.annotation.NonNull;
import com.google.firebase.messaging.FirebaseMessagingService;
import com.google.firebase.messaging.RemoteMessage;
import com.yandex.metrica.push.common.PushServiceFacade;
import com.yandex.metrica.push.common.utils.CoreUtils;
import com.yandex.metrica.push.common.utils.PublicLogger;
import com.yandex.metrica.push.common.utils.TrackersHub;
import java.util.Map;

public class MetricaMessagingService
extends FirebaseMessagingService {
    public static boolean isNotificationRelatedToSDK(@NonNull RemoteMessage remoteMessage) {
        return CoreUtils.isNotificationRelatedToSDK((Bundle)CoreUtils.fromMapToBundle((Map)remoteMessage.getData()));
    }

    public void onMessageReceived(@NonNull RemoteMessage remoteMessage) {
        MetricaMessagingService metricaMessagingService = this;
        super.onMessageReceived(remoteMessage);
        metricaMessagingService.processPush((Context)this, remoteMessage);
    }

    public void onNewToken(@NonNull String string) {
        MetricaMessagingService metricaMessagingService = this;
        super.onNewToken(string);
        metricaMessagingService.processToken((Context)this, string);
    }

    public void processPush(@NonNull Context context, @NonNull RemoteMessage remoteMessage) {
        try {
            this.processPush(context, CoreUtils.fromMapToBundle((Map)remoteMessage.getData()));
        }
        catch (Throwable throwable) {
            TrackersHub.getInstance().reportError("Failed to process firebase push", throwable);
        }
    }

    public void processPush(@NonNull Context context, @NonNull Bundle bundle) {
        try {
            PublicLogger.d((String)"Receive\nfullData: %s", (Object[])new Object[]{bundle});
            TrackersHub.getInstance().reportEvent("FirebaseMessagingService receive push");
            PushServiceFacade.processPush((Context)context, (Bundle)bundle, (String)"firebase");
        }
        catch (Throwable throwable) {
            TrackersHub.getInstance().reportError("Failed to process firebase push", throwable);
        }
    }

    public void processToken(@NonNull Context context, @NonNull String string) {
        try {
            TrackersHub.getInstance().reportEvent("FirebaseInstanceIdService refresh token");
            PushServiceFacade.refreshToken((Context)context);
        }
        catch (Throwable throwable) {
            TrackersHub.getInstance().reportError("Failed to refresh firebase token", throwable);
        }
    }
}

