/*
 * Decompiled with CFR 0.152.
 */
package androidx.core.app;

import android.app.Service;
import android.app.job.JobParameters;
import android.app.job.JobServiceEngine;
import android.app.job.JobWorkItem;
import android.content.Intent;
import android.os.Build;
import android.os.IBinder;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import androidx.core.app.JobIntentService;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public abstract class FixedJobIntentService
extends JobIntentService {
    JobIntentService.GenericWorkItem dequeueWork() {
        try {
            return super.dequeueWork();
        }
        catch (SecurityException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void onCreate() {
        super.onCreate();
        if (Build.VERSION.SDK_INT >= 26) {
            this.mJobImpl = new FixedJobServiceEngineImpl(this);
        }
    }

    @RequiresApi(value=26)
    static final class FixedJobServiceEngineImpl
    extends JobServiceEngine
    implements JobIntentService.CompatJobEngine {
        static final String TAG = "JobServiceEngineImpl";
        static final boolean DEBUG = false;
        final JobIntentService mService;
        final Object mLock = new Object();
        JobParameters mParams;

        FixedJobServiceEngineImpl(JobIntentService service) {
            super((Service)service);
            this.mService = service;
        }

        public IBinder compatGetBinder() {
            return this.getBinder();
        }

        public boolean onStartJob(JobParameters params) {
            this.mParams = params;
            this.mService.ensureProcessorRunningLocked(false);
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean onStopJob(JobParameters params) {
            boolean result = this.mService.doStopCurrentWork();
            Object object = this.mLock;
            synchronized (object) {
                this.mParams = null;
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public JobIntentService.GenericWorkItem dequeueWork() {
            JobWorkItem work = null;
            Object object = this.mLock;
            synchronized (object) {
                if (this.mParams == null) {
                    return null;
                }
                try {
                    work = this.mParams.dequeueWork();
                }
                catch (SecurityException exc) {
                    exc.printStackTrace();
                }
            }
            if (work != null) {
                work.getIntent().setExtrasClassLoader(this.mService.getClassLoader());
                return new WrapperWorkItem(work);
            }
            return null;
        }

        final class WrapperWorkItem
        implements JobIntentService.GenericWorkItem {
            final JobWorkItem mJobWork;

            WrapperWorkItem(JobWorkItem jobWork) {
                this.mJobWork = jobWork;
            }

            public Intent getIntent() {
                return this.mJobWork.getIntent();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void complete() {
                Object object = FixedJobServiceEngineImpl.this.mLock;
                synchronized (object) {
                    if (FixedJobServiceEngineImpl.this.mParams != null) {
                        try {
                            FixedJobServiceEngineImpl.this.mParams.completeWork(this.mJobWork);
                        }
                        catch (SecurityException exc) {
                            exc.printStackTrace();
                        }
                    }
                }
            }
        }
    }
}

