/*
 * Decompiled with CFR 0.152.
 */
package com.evernote.android.job.patched.internal;

import android.app.Service;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ResolveInfo;
import android.os.Build;
import androidx.annotation.NonNull;
import com.evernote.android.job.patched.internal.JobConfig;
import com.evernote.android.job.patched.internal.JobProxy;
import com.evernote.android.job.patched.internal.v14.JobProxy14;
import com.evernote.android.job.patched.internal.v14.PlatformAlarmReceiver;
import com.evernote.android.job.patched.internal.v14.PlatformAlarmService;
import com.evernote.android.job.patched.internal.v14.PlatformAlarmServiceExact;
import com.evernote.android.job.patched.internal.v19.JobProxy19;
import com.evernote.android.job.patched.internal.v21.JobProxy21;
import com.evernote.android.job.patched.internal.v21.PlatformJobService;
import com.evernote.android.job.patched.internal.v24.JobProxy24;
import com.evernote.android.job.patched.internal.v26.JobProxy26;
import java.util.List;

public enum JobApi {
    V_26(true, false, true),
    V_24(true, false, false),
    V_21(true, true, false),
    V_19(true, true, true),
    V_14(false, true, true);

    private static final String JOB_SCHEDULER_PERMISSION = "android.permission.BIND_JOB_SERVICE";
    private volatile JobProxy mCachedProxy;
    private final boolean mSupportsExecutionWindow;
    private final boolean mFlexSupport;
    private final boolean mSupportsTransientJobs;

    private JobApi(boolean supportsExecutionWindow, boolean flexSupport, boolean supportsTransientJobs) {
        this.mSupportsExecutionWindow = supportsExecutionWindow;
        this.mFlexSupport = flexSupport;
        this.mSupportsTransientJobs = supportsTransientJobs;
    }

    boolean supportsExecutionWindow() {
        return this.mSupportsExecutionWindow;
    }

    boolean isFlexSupport() {
        return this.mFlexSupport;
    }

    boolean supportsTransientJobs() {
        return this.mSupportsTransientJobs;
    }

    public boolean isSupported(Context context) {
        switch (this) {
            case V_26: {
                return Build.VERSION.SDK_INT >= 26 && this.isServiceEnabled(context, PlatformJobService.class);
            }
            case V_24: {
                return Build.VERSION.SDK_INT >= 24 && JobApi.isServiceEnabledAndHasPermission(context, PlatformJobService.class, JOB_SCHEDULER_PERMISSION);
            }
            case V_21: {
                return Build.VERSION.SDK_INT >= 21 && JobApi.isServiceEnabledAndHasPermission(context, PlatformJobService.class, JOB_SCHEDULER_PERMISSION);
            }
            case V_19: {
                return Build.VERSION.SDK_INT >= 19 && this.isServiceEnabled(context, PlatformAlarmService.class) && this.isBroadcastEnabled(context, PlatformAlarmReceiver.class);
            }
            case V_14: {
                return JobConfig.isForceAllowApi14() || this.isServiceEnabled(context, PlatformAlarmService.class) && this.isServiceEnabled(context, PlatformAlarmServiceExact.class) && this.isBroadcastEnabled(context, PlatformAlarmReceiver.class);
            }
        }
        throw new IllegalStateException("not implemented");
    }

    @NonNull
    private JobProxy createProxy(Context context) {
        switch (this) {
            case V_26: {
                return new JobProxy26(context);
            }
            case V_24: {
                return new JobProxy24(context);
            }
            case V_21: {
                return new JobProxy21(context);
            }
            case V_19: {
                return new JobProxy19(context);
            }
            case V_14: {
                return new JobProxy14(context);
            }
        }
        throw new IllegalStateException("not implemented");
    }

    @NonNull
    synchronized JobProxy getProxy(Context context) {
        if (this.mCachedProxy == null) {
            this.mCachedProxy = this.createProxy(context);
        }
        return this.mCachedProxy;
    }

    public synchronized void invalidateCachedProxy() {
        this.mCachedProxy = null;
    }

    private boolean isServiceEnabled(@NonNull Context context, @NonNull Class<? extends Service> clazz) {
        try {
            Intent intent = new Intent(context, clazz);
            List resolveInfos = context.getPackageManager().queryIntentServices(intent, 0);
            return resolveInfos != null && !resolveInfos.isEmpty();
        }
        catch (Exception e) {
            return false;
        }
    }

    private static boolean isServiceEnabledAndHasPermission(@NonNull Context context, @NonNull Class<? extends Service> clazz, @NonNull String permission2) {
        try {
            Intent intent = new Intent(context, clazz);
            List resolveInfos = context.getPackageManager().queryIntentServices(intent, 0);
            if (resolveInfos == null || resolveInfos.isEmpty()) {
                return false;
            }
            for (ResolveInfo info : resolveInfos) {
                if (info.serviceInfo == null || !permission2.equals(info.serviceInfo.permission)) continue;
                return true;
            }
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean isBroadcastEnabled(@NonNull Context context, @NonNull Class<? extends BroadcastReceiver> clazz) {
        try {
            Intent intent = new Intent(context, clazz);
            List resolveInfos = context.getPackageManager().queryBroadcastReceivers(intent, 0);
            return resolveInfos != null && !resolveInfos.isEmpty();
        }
        catch (Exception e) {
            return false;
        }
    }

    @NonNull
    public static JobApi getDefault(Context context) {
        if (V_26.isSupported(context) && JobConfig.isApiEnabled(V_26)) {
            return V_26;
        }
        if (V_24.isSupported(context) && JobConfig.isApiEnabled(V_24)) {
            return V_24;
        }
        if (V_21.isSupported(context) && JobConfig.isApiEnabled(V_21)) {
            return V_21;
        }
        if (V_19.isSupported(context) && JobConfig.isApiEnabled(V_19)) {
            return V_19;
        }
        if (JobConfig.isApiEnabled(V_14)) {
            return V_14;
        }
        throw new IllegalStateException("All supported APIs are disabled");
    }
}

