/*
 * Decompiled with CFR 0.152.
 */
package com.evernote.android.job.patched.internal;

import android.app.Service;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Looper;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.evernote.android.job.patched.internal.Job;
import com.evernote.android.job.patched.internal.JobApi;
import com.evernote.android.job.patched.internal.JobExecutor;
import com.evernote.android.job.patched.internal.JobManager;
import com.evernote.android.job.patched.internal.JobManagerCreateException;
import com.evernote.android.job.patched.internal.JobRequest;
import com.evernote.android.job.patched.internal.WakeLockUtil;
import com.evernote.android.job.patched.internal.util.JobCat;
import com.evernote.android.job.patched.internal.util.JobUtil;
import java.util.Locale;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public interface JobProxy {
    public void plantOneOff(JobRequest var1);

    public void plantPeriodic(JobRequest var1);

    public void plantPeriodicFlexSupport(JobRequest var1);

    public void cancel(int var1);

    public boolean isPlatformJobScheduled(JobRequest var1);

    public static final class Common {
        private static final Object COMMON_MONITOR = new Object();
        private final Context mContext;
        private final int mJobId;
        private final JobCat mCat;
        private final JobManager mJobManager;

        private static long checkedAdd(long a, long b) {
            long result = a + b;
            return Common.checkNoOverflow(result, (a ^ b) < 0L | (a ^ result) >= 0L);
        }

        private static long checkedMultiply(long a, long b) {
            int leadingZeros = Long.numberOfLeadingZeros(a) + Long.numberOfLeadingZeros(a ^ 0xFFFFFFFFFFFFFFFFL) + Long.numberOfLeadingZeros(b) + Long.numberOfLeadingZeros(b ^ 0xFFFFFFFFFFFFFFFFL);
            if (leadingZeros > 65) {
                return a * b;
            }
            long result = a * b;
            result = Common.checkNoOverflow(result, leadingZeros >= 64);
            result = Common.checkNoOverflow(result, a >= 0L | b != Long.MIN_VALUE);
            result = Common.checkNoOverflow(result, a == 0L || result / a == b);
            return result;
        }

        private static long checkNoOverflow(long result, boolean condition) {
            return condition ? result : Long.MAX_VALUE;
        }

        public static long getStartMs(JobRequest request) {
            if (request.getFailureCount() > 0) {
                return request.getBackoffOffset();
            }
            return request.getStartMs();
        }

        public static long getEndMs(JobRequest request) {
            return Common.getEndMs(request, false);
        }

        public static long getEndMs(JobRequest request, boolean shiftEnd) {
            long endMs = request.getFailureCount() > 0 ? request.getBackoffOffset() : request.getEndMs();
            if (shiftEnd && request.requirementsEnforced() && request.hasRequirements()) {
                endMs = Common.checkedMultiply(endMs, 100L);
            }
            return endMs;
        }

        public static long getAverageDelayMs(JobRequest request) {
            return Common.checkedAdd(Common.getStartMs(request), (Common.getEndMs(request) - Common.getStartMs(request)) / 2L);
        }

        public static long getStartMsSupportFlex(JobRequest request) {
            return Math.max(1L, request.getIntervalMs() - request.getFlexMs());
        }

        public static long getEndMsSupportFlex(JobRequest request) {
            return request.getIntervalMs();
        }

        public static long getAverageDelayMsSupportFlex(JobRequest request) {
            return Common.checkedAdd(Common.getStartMsSupportFlex(request), (Common.getEndMsSupportFlex(request) - Common.getStartMsSupportFlex(request)) / 2L);
        }

        public static int getRescheduleCount(JobRequest request) {
            return request.getFailureCount();
        }

        public Common(@NonNull Service service, JobCat cat, int jobId) {
            this((Context)service, cat, jobId);
        }

        Common(@NonNull Context context, JobCat cat, int jobId) {
            JobManager manager;
            this.mContext = context;
            this.mJobId = jobId;
            this.mCat = cat;
            try {
                manager = JobManager.create(context);
            }
            catch (JobManagerCreateException e) {
                this.mCat.e(e);
                manager = null;
            }
            this.mJobManager = manager;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public JobRequest getPendingRequest(boolean cleanUpOrphanedJob, boolean markStarting) {
            Object object = COMMON_MONITOR;
            synchronized (object) {
                boolean periodic;
                if (this.mJobManager == null) {
                    return null;
                }
                JobRequest request = this.mJobManager.getJobRequest(this.mJobId, true);
                Job job = this.mJobManager.getJob(this.mJobId);
                boolean bl = periodic = request != null && request.isPeriodic();
                if (job != null && !job.isFinished()) {
                    this.mCat.d("Job %d is already running, %s", this.mJobId, request);
                    return null;
                }
                if (job != null && !periodic) {
                    this.mCat.d("Job %d already finished, %s", this.mJobId, request);
                    this.cleanUpOrphanedJob(cleanUpOrphanedJob);
                    return null;
                }
                if (job != null && System.currentTimeMillis() - job.getFinishedTimeStamp() < 2000L) {
                    this.mCat.d("Job %d is periodic and just finished, %s", this.mJobId, request);
                    return null;
                }
                if (request != null && request.isStarted()) {
                    this.mCat.d("Request %d already started, %s", this.mJobId, request);
                    return null;
                }
                if (request != null && this.mJobManager.getJobExecutor().isRequestStarting(request)) {
                    this.mCat.d("Request %d is in the queue to start, %s", this.mJobId, request);
                    return null;
                }
                if (request == null) {
                    this.mCat.d("Request for ID %d was null", this.mJobId);
                    this.cleanUpOrphanedJob(cleanUpOrphanedJob);
                    return null;
                }
                if (markStarting) {
                    this.markStarting(request);
                }
                return request;
            }
        }

        public void markStarting(@NonNull JobRequest request) {
            this.mJobManager.getJobExecutor().markJobRequestStarting(request);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NonNull
        public Job.Result executeJobRequest(@NonNull JobRequest request, @Nullable Bundle transientExtras) {
            long waited = System.currentTimeMillis() - request.getScheduledAt();
            String timeWindow = request.isPeriodic() ? String.format(Locale.US, "interval %s, flex %s", JobUtil.timeToString(request.getIntervalMs()), JobUtil.timeToString(request.getFlexMs())) : (request.getJobApi().supportsExecutionWindow() ? String.format(Locale.US, "start %s, end %s", JobUtil.timeToString(Common.getStartMs(request)), JobUtil.timeToString(Common.getEndMs(request))) : "delay " + JobUtil.timeToString(Common.getAverageDelayMs(request)));
            if (Looper.myLooper() == Looper.getMainLooper()) {
                this.mCat.w("Running JobRequest on a main thread, this could cause stutter or ANR in your app.");
            }
            this.mCat.d("Run job, %s, waited %s, %s", request, JobUtil.timeToString(waited), timeWindow);
            JobExecutor jobExecutor = this.mJobManager.getJobExecutor();
            Job job = null;
            try {
                Future<Job.Result> future;
                job = this.mJobManager.getJobCreatorHolder().createJob(request.getTag());
                if (!request.isPeriodic()) {
                    request.setStarted(true);
                }
                if (transientExtras == null) {
                    transientExtras = Bundle.EMPTY;
                }
                if ((future = jobExecutor.execute(this.mContext, request, job, transientExtras)) == null) {
                    Job.Result result = Job.Result.FAILURE;
                    return result;
                }
                Job.Result result = future.get();
                this.mCat.d("Finished job, %s %s", new Object[]{request, result});
                Job.Result result2 = result;
                return result2;
            }
            catch (InterruptedException | ExecutionException e) {
                this.mCat.e(e);
                if (job != null) {
                    job.cancel();
                    this.mCat.e("Canceled %s", request);
                }
                Job.Result result = Job.Result.FAILURE;
                return result;
            }
            finally {
                if (job == null) {
                    this.mJobManager.getJobStorage().remove(request);
                } else if (!request.isPeriodic()) {
                    this.mJobManager.getJobStorage().remove(request);
                } else if (request.isFlexSupport() && !job.isDeleted()) {
                    this.mJobManager.getJobStorage().remove(request);
                    request.reschedule(false, false);
                }
            }
        }

        private void cleanUpOrphanedJob(boolean cleanUp) {
            if (cleanUp) {
                Common.cleanUpOrphanedJob(this.mContext, this.mJobId);
            }
        }

        static void cleanUpOrphanedJob(Context context, int jobId) {
            for (JobApi jobApi : JobApi.values()) {
                if (!jobApi.isSupported(context)) continue;
                try {
                    jobApi.getProxy(context).cancel(jobId);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        public static ComponentName startWakefulService(Context context, Intent intent) {
            return WakeLockUtil.startWakefulService(context, intent);
        }

        public static boolean completeWakefulIntent(Intent intent) {
            return WakeLockUtil.completeWakefulIntent(intent);
        }
    }
}

