/*
 * Decompiled with CFR 0.152.
 */
package com.evernote.android.job.patched.internal;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.os.Bundle;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.evernote.android.job.patched.internal.JobApi;
import com.evernote.android.job.patched.internal.JobConfig;
import com.evernote.android.job.patched.internal.JobManager;
import com.evernote.android.job.patched.internal.util.JobCat;
import com.evernote.android.job.patched.internal.util.JobPreconditions;
import com.evernote.android.job.patched.internal.util.support.PersistableBundleCompat;
import java.util.concurrent.TimeUnit;

public final class JobRequest {
    public static final long DEFAULT_BACKOFF_MS = 30000L;
    public static final BackoffPolicy DEFAULT_BACKOFF_POLICY = BackoffPolicy.EXPONENTIAL;
    public static final NetworkType DEFAULT_NETWORK_TYPE = NetworkType.ANY;
    public static final JobScheduledCallback DEFAULT_JOB_SCHEDULED_CALLBACK = new JobScheduledCallback(){

        @Override
        public void onJobScheduled(int jobId, @NonNull String tag, @Nullable Exception exception) {
            if (exception != null) {
                CAT.e(exception, "The job with tag %s couldn't be scheduled", tag);
            }
        }
    };
    public static final long MIN_INTERVAL = TimeUnit.MINUTES.toMillis(15L);
    public static final long MIN_FLEX = TimeUnit.MINUTES.toMillis(5L);
    private static final long WINDOW_THRESHOLD_WARNING = 0x2AAAAAAAAAAAAAAAL;
    private static final long WINDOW_THRESHOLD_MAX = 0x5555555555555554L;
    private static final JobCat CAT = new JobCat("JobRequest");
    static final long START_NOW = 1L;
    private final Builder mBuilder;
    private int mFailureCount;
    private long mScheduledAt;
    private boolean mStarted;
    private boolean mFlexSupport;
    private long mLastRun;

    static long getMinInterval() {
        return JobConfig.isAllowSmallerIntervalsForMarshmallow() ? TimeUnit.MINUTES.toMillis(1L) : MIN_INTERVAL;
    }

    static long getMinFlex() {
        return JobConfig.isAllowSmallerIntervalsForMarshmallow() ? TimeUnit.SECONDS.toMillis(30L) : MIN_FLEX;
    }

    private static Context context() {
        return JobManager.instance().getContext();
    }

    private JobRequest(Builder builder) {
        this.mBuilder = builder;
    }

    public int getJobId() {
        return this.mBuilder.mId;
    }

    @NonNull
    public String getTag() {
        return this.mBuilder.mTag;
    }

    public long getStartMs() {
        return this.mBuilder.mStartMs;
    }

    public long getEndMs() {
        return this.mBuilder.mEndMs;
    }

    public BackoffPolicy getBackoffPolicy() {
        return this.mBuilder.mBackoffPolicy;
    }

    public long getBackoffMs() {
        return this.mBuilder.mBackoffMs;
    }

    public boolean isPeriodic() {
        return this.getIntervalMs() > 0L;
    }

    public long getIntervalMs() {
        return this.mBuilder.mIntervalMs;
    }

    public long getFlexMs() {
        return this.mBuilder.mFlexMs;
    }

    public boolean requirementsEnforced() {
        return this.mBuilder.mRequirementsEnforced;
    }

    public boolean requiresCharging() {
        return this.mBuilder.mRequiresCharging;
    }

    public boolean requiresDeviceIdle() {
        return this.mBuilder.mRequiresDeviceIdle;
    }

    public boolean requiresBatteryNotLow() {
        return this.mBuilder.mRequiresBatteryNotLow;
    }

    public boolean requiresStorageNotLow() {
        return this.mBuilder.mRequiresStorageNotLow;
    }

    public NetworkType requiredNetworkType() {
        return this.mBuilder.mNetworkType;
    }

    public boolean hasRequirements() {
        return this.requiresCharging() || this.requiresDeviceIdle() || this.requiresBatteryNotLow() || this.requiresStorageNotLow() || this.requiredNetworkType() != DEFAULT_NETWORK_TYPE;
    }

    public PersistableBundleCompat getExtras() {
        if (this.mBuilder.mExtras == null && !TextUtils.isEmpty((CharSequence)this.mBuilder.mExtrasXml)) {
            this.mBuilder.mExtras = PersistableBundleCompat.fromXml(this.mBuilder.mExtrasXml);
        }
        return this.mBuilder.mExtras;
    }

    public boolean isUpdateCurrent() {
        return this.mBuilder.mUpdateCurrent;
    }

    public boolean isExact() {
        return this.mBuilder.mExact;
    }

    long getBackoffOffset() {
        long offset;
        if (this.isPeriodic()) {
            return 0L;
        }
        switch (this.getBackoffPolicy()) {
            case LINEAR: {
                offset = (long)this.mFailureCount * this.getBackoffMs();
                break;
            }
            case EXPONENTIAL: {
                if (this.mFailureCount == 0) {
                    offset = 0L;
                    break;
                }
                offset = (long)((double)this.getBackoffMs() * Math.pow(2.0, this.mFailureCount - 1));
                break;
            }
            default: {
                throw new IllegalStateException("not implemented");
            }
        }
        return Math.min(offset, TimeUnit.HOURS.toMillis(5L));
    }

    JobApi getJobApi() {
        return this.mBuilder.mExact ? JobApi.V_14 : JobApi.getDefault(JobRequest.context());
    }

    void setScheduledAt(long timeStamp) {
        this.mScheduledAt = timeStamp;
    }

    public long getScheduledAt() {
        return this.mScheduledAt;
    }

    public int getFailureCount() {
        return this.mFailureCount;
    }

    boolean isStarted() {
        return this.mStarted;
    }

    boolean isFlexSupport() {
        return this.mFlexSupport;
    }

    void setFlexSupport(boolean flexSupport) {
        this.mFlexSupport = flexSupport;
    }

    public long getLastRun() {
        return this.mLastRun;
    }

    public boolean isTransient() {
        return this.mBuilder.mTransient;
    }

    @NonNull
    public Bundle getTransientExtras() {
        return this.mBuilder.mTransientExtras;
    }

    public int schedule() {
        JobManager.instance().schedule(this);
        return this.getJobId();
    }

    public void scheduleAsync() {
        this.scheduleAsync(DEFAULT_JOB_SCHEDULED_CALLBACK);
    }

    public void scheduleAsync(final @NonNull JobScheduledCallback callback) {
        JobPreconditions.checkNotNull(callback);
        JobConfig.getExecutorService().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    int jobId = JobRequest.this.schedule();
                    callback.onJobScheduled(jobId, JobRequest.this.getTag(), null);
                }
                catch (Exception e) {
                    callback.onJobScheduled(-1, JobRequest.this.getTag(), e);
                }
            }
        });
    }

    public Builder cancelAndEdit() {
        long scheduledAt = this.mScheduledAt;
        JobManager.instance().cancel(this.getJobId());
        Builder builder = new Builder(this.mBuilder);
        this.mStarted = false;
        if (!this.isPeriodic()) {
            long offset = JobConfig.getClock().currentTimeMillis() - scheduledAt;
            long minValue = 1L;
            builder.setExecutionWindow(Math.max(minValue, this.getStartMs() - offset), Math.max(minValue, this.getEndMs() - offset));
        }
        return builder;
    }

    Builder createBuilder() {
        return new Builder(this.mBuilder, true);
    }

    JobRequest reschedule(boolean failure, boolean newJob) {
        JobRequest newRequest = new Builder(this.mBuilder, newJob).build();
        if (failure) {
            newRequest.mFailureCount = this.mFailureCount + 1;
        }
        try {
            newRequest.schedule();
        }
        catch (Exception e) {
            CAT.e(e);
        }
        return newRequest;
    }

    void updateStats(boolean incFailureCount, boolean updateLastRun) {
        ContentValues contentValues = new ContentValues();
        if (incFailureCount) {
            ++this.mFailureCount;
            contentValues.put("numFailures", Integer.valueOf(this.mFailureCount));
        }
        if (updateLastRun) {
            this.mLastRun = JobConfig.getClock().currentTimeMillis();
            contentValues.put("lastRun", Long.valueOf(this.mLastRun));
        }
        JobManager.instance().getJobStorage().update(this, contentValues);
    }

    void setStarted(boolean started) {
        this.mStarted = started;
        ContentValues contentValues = new ContentValues();
        contentValues.put("started", Boolean.valueOf(this.mStarted));
        JobManager.instance().getJobStorage().update(this, contentValues);
    }

    ContentValues toContentValues() {
        ContentValues contentValues = new ContentValues();
        this.mBuilder.fillContentValues(contentValues);
        contentValues.put("numFailures", Integer.valueOf(this.mFailureCount));
        contentValues.put("scheduledAt", Long.valueOf(this.mScheduledAt));
        contentValues.put("started", Boolean.valueOf(this.mStarted));
        contentValues.put("flexSupport", Boolean.valueOf(this.mFlexSupport));
        contentValues.put("lastRun", Long.valueOf(this.mLastRun));
        return contentValues;
    }

    static JobRequest fromCursor(Cursor cursor) {
        JobRequest request = new Builder(cursor).build();
        request.mFailureCount = cursor.getInt(cursor.getColumnIndex("numFailures"));
        request.mScheduledAt = cursor.getLong(cursor.getColumnIndex("scheduledAt"));
        request.mStarted = cursor.getInt(cursor.getColumnIndex("started")) > 0;
        request.mFlexSupport = cursor.getInt(cursor.getColumnIndex("flexSupport")) > 0;
        request.mLastRun = cursor.getLong(cursor.getColumnIndex("lastRun"));
        JobPreconditions.checkArgumentNonnegative(request.mFailureCount, "failure count can't be negative");
        JobPreconditions.checkArgumentNonnegative(request.mScheduledAt, "scheduled at can't be negative");
        return request;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JobRequest request = (JobRequest)o;
        return this.mBuilder.equals(request.mBuilder);
    }

    public int hashCode() {
        return this.mBuilder.hashCode();
    }

    public String toString() {
        return "request{id=" + this.getJobId() + ", tag=" + this.getTag() + ", transient=" + this.isTransient() + '}';
    }

    public static interface JobScheduledCallback {
        public static final int JOB_ID_ERROR = -1;

        public void onJobScheduled(int var1, @NonNull String var2, @Nullable Exception var3);
    }

    public static enum NetworkType {
        ANY,
        CONNECTED,
        UNMETERED,
        NOT_ROAMING,
        METERED;

    }

    public static enum BackoffPolicy {
        LINEAR,
        EXPONENTIAL;

    }

    public static final class Builder {
        private static final int CREATE_ID = -8765;
        private int mId;
        final String mTag;
        private long mStartMs;
        private long mEndMs;
        private long mBackoffMs;
        private BackoffPolicy mBackoffPolicy;
        private long mIntervalMs;
        private long mFlexMs;
        private boolean mRequirementsEnforced;
        private boolean mRequiresCharging;
        private boolean mRequiresDeviceIdle;
        private boolean mRequiresBatteryNotLow;
        private boolean mRequiresStorageNotLow;
        private boolean mExact;
        private NetworkType mNetworkType;
        private PersistableBundleCompat mExtras;
        private String mExtrasXml;
        private boolean mUpdateCurrent;
        private boolean mTransient;
        private Bundle mTransientExtras = Bundle.EMPTY;

        public Builder(@NonNull String tag) {
            this.mTag = JobPreconditions.checkNotEmpty(tag);
            this.mId = -8765;
            this.mStartMs = -1L;
            this.mEndMs = -1L;
            this.mBackoffMs = 30000L;
            this.mBackoffPolicy = DEFAULT_BACKOFF_POLICY;
            this.mNetworkType = DEFAULT_NETWORK_TYPE;
        }

        private Builder(Cursor cursor) {
            this.mId = cursor.getInt(cursor.getColumnIndex("_id"));
            this.mTag = cursor.getString(cursor.getColumnIndex("tag"));
            this.mStartMs = cursor.getLong(cursor.getColumnIndex("startMs"));
            this.mEndMs = cursor.getLong(cursor.getColumnIndex("endMs"));
            this.mBackoffMs = cursor.getLong(cursor.getColumnIndex("backoffMs"));
            try {
                this.mBackoffPolicy = BackoffPolicy.valueOf(cursor.getString(cursor.getColumnIndex("backoffPolicy")));
            }
            catch (Throwable t) {
                CAT.e(t);
                this.mBackoffPolicy = DEFAULT_BACKOFF_POLICY;
            }
            this.mIntervalMs = cursor.getLong(cursor.getColumnIndex("intervalMs"));
            this.mFlexMs = cursor.getLong(cursor.getColumnIndex("flexMs"));
            this.mRequirementsEnforced = cursor.getInt(cursor.getColumnIndex("requirementsEnforced")) > 0;
            this.mRequiresCharging = cursor.getInt(cursor.getColumnIndex("requiresCharging")) > 0;
            this.mRequiresDeviceIdle = cursor.getInt(cursor.getColumnIndex("requiresDeviceIdle")) > 0;
            this.mRequiresBatteryNotLow = cursor.getInt(cursor.getColumnIndex("requiresBatteryNotLow")) > 0;
            this.mRequiresStorageNotLow = cursor.getInt(cursor.getColumnIndex("requiresStorageNotLow")) > 0;
            this.mExact = cursor.getInt(cursor.getColumnIndex("exact")) > 0;
            try {
                this.mNetworkType = NetworkType.valueOf(cursor.getString(cursor.getColumnIndex("networkType")));
            }
            catch (Throwable t) {
                CAT.e(t);
                this.mNetworkType = DEFAULT_NETWORK_TYPE;
            }
            this.mExtrasXml = cursor.getString(cursor.getColumnIndex("extras"));
            this.mTransient = cursor.getInt(cursor.getColumnIndex("transient")) > 0;
        }

        private Builder(@NonNull Builder builder) {
            this(builder, false);
        }

        private Builder(@NonNull Builder builder, boolean createId) {
            this.mId = createId ? -8765 : builder.mId;
            this.mTag = builder.mTag;
            this.mStartMs = builder.mStartMs;
            this.mEndMs = builder.mEndMs;
            this.mBackoffMs = builder.mBackoffMs;
            this.mBackoffPolicy = builder.mBackoffPolicy;
            this.mIntervalMs = builder.mIntervalMs;
            this.mFlexMs = builder.mFlexMs;
            this.mRequirementsEnforced = builder.mRequirementsEnforced;
            this.mRequiresCharging = builder.mRequiresCharging;
            this.mRequiresDeviceIdle = builder.mRequiresDeviceIdle;
            this.mRequiresBatteryNotLow = builder.mRequiresBatteryNotLow;
            this.mRequiresStorageNotLow = builder.mRequiresStorageNotLow;
            this.mExact = builder.mExact;
            this.mNetworkType = builder.mNetworkType;
            this.mExtras = builder.mExtras;
            this.mExtrasXml = builder.mExtrasXml;
            this.mUpdateCurrent = builder.mUpdateCurrent;
            this.mTransient = builder.mTransient;
            this.mTransientExtras = builder.mTransientExtras;
        }

        private void fillContentValues(ContentValues contentValues) {
            contentValues.put("_id", Integer.valueOf(this.mId));
            contentValues.put("tag", this.mTag);
            contentValues.put("startMs", Long.valueOf(this.mStartMs));
            contentValues.put("endMs", Long.valueOf(this.mEndMs));
            contentValues.put("backoffMs", Long.valueOf(this.mBackoffMs));
            contentValues.put("backoffPolicy", this.mBackoffPolicy.toString());
            contentValues.put("intervalMs", Long.valueOf(this.mIntervalMs));
            contentValues.put("flexMs", Long.valueOf(this.mFlexMs));
            contentValues.put("requirementsEnforced", Boolean.valueOf(this.mRequirementsEnforced));
            contentValues.put("requiresCharging", Boolean.valueOf(this.mRequiresCharging));
            contentValues.put("requiresDeviceIdle", Boolean.valueOf(this.mRequiresDeviceIdle));
            contentValues.put("requiresBatteryNotLow", Boolean.valueOf(this.mRequiresBatteryNotLow));
            contentValues.put("requiresStorageNotLow", Boolean.valueOf(this.mRequiresStorageNotLow));
            contentValues.put("exact", Boolean.valueOf(this.mExact));
            contentValues.put("networkType", this.mNetworkType.toString());
            if (this.mExtras != null) {
                contentValues.put("extras", this.mExtras.saveToXml());
            } else if (!TextUtils.isEmpty((CharSequence)this.mExtrasXml)) {
                contentValues.put("extras", this.mExtrasXml);
            }
            contentValues.put("transient", Boolean.valueOf(this.mTransient));
        }

        public Builder setExecutionWindow(long startInMs, long endInMs) {
            this.mStartMs = JobPreconditions.checkArgumentPositive(startInMs, "startInMs must be greater than 0");
            this.mEndMs = JobPreconditions.checkArgumentInRange(endInMs, startInMs, Long.MAX_VALUE, "endInMs");
            if (this.mStartMs > 0x5555555555555554L) {
                CAT.i("startInMs reduced from %d days to %d days", TimeUnit.MILLISECONDS.toDays(this.mStartMs), TimeUnit.MILLISECONDS.toDays(0x5555555555555554L));
                this.mStartMs = 0x5555555555555554L;
            }
            if (this.mEndMs > 0x5555555555555554L) {
                CAT.i("endInMs reduced from %d days to %d days", TimeUnit.MILLISECONDS.toDays(this.mEndMs), TimeUnit.MILLISECONDS.toDays(0x5555555555555554L));
                this.mEndMs = 0x5555555555555554L;
            }
            return this;
        }

        public Builder setExtras(@Nullable PersistableBundleCompat extras) {
            if (extras == null) {
                this.mExtras = null;
                this.mExtrasXml = null;
            } else {
                this.mExtras = new PersistableBundleCompat(extras);
            }
            return this;
        }

        public Builder addExtras(@NonNull PersistableBundleCompat extras) {
            if (this.mExtras == null) {
                this.mExtras = extras;
            } else {
                this.mExtras.putAll(extras);
            }
            this.mExtrasXml = null;
            return this;
        }

        public Builder setRequirementsEnforced(boolean enforced) {
            this.mRequirementsEnforced = enforced;
            return this;
        }

        public Builder setRequiredNetworkType(@Nullable NetworkType networkType) {
            this.mNetworkType = networkType;
            return this;
        }

        public Builder setRequiresCharging(boolean requiresCharging) {
            this.mRequiresCharging = requiresCharging;
            return this;
        }

        public Builder setRequiresDeviceIdle(boolean requiresDeviceIdle) {
            this.mRequiresDeviceIdle = requiresDeviceIdle;
            return this;
        }

        public Builder setRequiresBatteryNotLow(boolean requiresBatteryNotLow) {
            this.mRequiresBatteryNotLow = requiresBatteryNotLow;
            return this;
        }

        public Builder setRequiresStorageNotLow(boolean requiresStorageNotLow) {
            this.mRequiresStorageNotLow = requiresStorageNotLow;
            return this;
        }

        public Builder setExact(long exactInMs) {
            this.mExact = true;
            if (exactInMs > 0x5555555555555554L) {
                CAT.i("exactInMs clamped from %d days to %d days", TimeUnit.MILLISECONDS.toDays(exactInMs), TimeUnit.MILLISECONDS.toDays(0x5555555555555554L));
                exactInMs = 0x5555555555555554L;
            }
            return this.setExecutionWindow(exactInMs, exactInMs);
        }

        public Builder startNow() {
            return this.setExact(1L);
        }

        public Builder setPeriodic(long intervalMs) {
            return this.setPeriodic(intervalMs, intervalMs);
        }

        public Builder setPeriodic(long intervalMs, long flexMs) {
            this.mIntervalMs = JobPreconditions.checkArgumentInRange(intervalMs, JobRequest.getMinInterval(), Long.MAX_VALUE, "intervalMs");
            this.mFlexMs = JobPreconditions.checkArgumentInRange(flexMs, JobRequest.getMinFlex(), this.mIntervalMs, "flexMs");
            return this;
        }

        public Builder setBackoffCriteria(long backoffMs, @NonNull BackoffPolicy backoffPolicy) {
            this.mBackoffMs = JobPreconditions.checkArgumentPositive(backoffMs, "backoffMs must be > 0");
            this.mBackoffPolicy = JobPreconditions.checkNotNull(backoffPolicy);
            return this;
        }

        public Builder setUpdateCurrent(boolean updateCurrent) {
            this.mUpdateCurrent = updateCurrent;
            return this;
        }

        public Builder setTransientExtras(@Nullable Bundle extras) {
            this.mTransient = extras != null && !extras.isEmpty();
            this.mTransientExtras = this.mTransient ? new Bundle(extras) : Bundle.EMPTY;
            return this;
        }

        public JobRequest build() {
            JobPreconditions.checkNotEmpty(this.mTag);
            JobPreconditions.checkArgumentPositive(this.mBackoffMs, "backoffMs must be > 0");
            JobPreconditions.checkNotNull(this.mBackoffPolicy);
            JobPreconditions.checkNotNull(this.mNetworkType);
            if (this.mIntervalMs > 0L) {
                JobPreconditions.checkArgumentInRange(this.mIntervalMs, JobRequest.getMinInterval(), Long.MAX_VALUE, "intervalMs");
                JobPreconditions.checkArgumentInRange(this.mFlexMs, JobRequest.getMinFlex(), this.mIntervalMs, "flexMs");
                if (this.mIntervalMs < MIN_INTERVAL || this.mFlexMs < MIN_FLEX) {
                    CAT.w("AllowSmallerIntervals enabled, this will crash on Android N and later, interval %d (minimum is %d), flex %d (minimum is %d)", this.mIntervalMs, MIN_INTERVAL, this.mFlexMs, MIN_FLEX);
                }
            }
            if (this.mExact && this.mIntervalMs > 0L) {
                throw new IllegalArgumentException("Can't call setExact() on a periodic job.");
            }
            if (this.mExact && this.mStartMs != this.mEndMs) {
                throw new IllegalArgumentException("Can't call setExecutionWindow() for an exact job.");
            }
            if (this.mExact && (this.mRequirementsEnforced || this.mRequiresDeviceIdle || this.mRequiresCharging || !DEFAULT_NETWORK_TYPE.equals((Object)this.mNetworkType) || this.mRequiresBatteryNotLow || this.mRequiresStorageNotLow)) {
                throw new IllegalArgumentException("Can't require any condition for an exact job.");
            }
            if (this.mIntervalMs <= 0L && (this.mStartMs == -1L || this.mEndMs == -1L)) {
                throw new IllegalArgumentException("You're trying to build a job with no constraints, this is not allowed.");
            }
            if (this.mIntervalMs > 0L && (this.mStartMs != -1L || this.mEndMs != -1L)) {
                throw new IllegalArgumentException("Can't call setExecutionWindow() on a periodic job.");
            }
            if (!(this.mIntervalMs <= 0L || this.mBackoffMs == 30000L && DEFAULT_BACKOFF_POLICY.equals((Object)this.mBackoffPolicy))) {
                throw new IllegalArgumentException("A periodic job will not respect any back-off policy, so calling setBackoffCriteria() with setPeriodic() is an error.");
            }
            if (this.mIntervalMs <= 0L && (this.mStartMs > 0x2AAAAAAAAAAAAAAAL || this.mEndMs > 0x2AAAAAAAAAAAAAAAL)) {
                CAT.w("Attention: your execution window is too large. This could result in undesired behavior, see https://github.com/evernote/android-job/wiki/FAQ");
            }
            if (this.mIntervalMs <= 0L && this.mStartMs > TimeUnit.DAYS.toMillis(365L)) {
                CAT.w("Warning: job with tag %s scheduled over a year in the future", this.mTag);
            }
            if (this.mId != -8765) {
                JobPreconditions.checkArgumentNonnegative(this.mId, "id can't be negative");
            }
            Builder builder = new Builder(this);
            if (this.mId == -8765) {
                builder.mId = JobManager.instance().getJobStorage().nextJobId();
                JobPreconditions.checkArgumentNonnegative(builder.mId, "id can't be negative");
            }
            return new JobRequest(builder);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Builder builder = (Builder)o;
            return this.mId == builder.mId;
        }

        public int hashCode() {
            return this.mId;
        }
    }
}

