/*
 * Decompiled with CFR 0.152.
 */
package com.evernote.android.job.patched.internal;

import android.content.ContentValues;
import android.content.Context;
import android.content.SharedPreferences;
import android.database.Cursor;
import android.database.DatabaseErrorHandler;
import android.database.SQLException;
import android.database.sqlite.SQLiteCantOpenDatabaseException;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import android.text.TextUtils;
import android.util.LruCache;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.evernote.android.job.patched.internal.JobConfig;
import com.evernote.android.job.patched.internal.JobRequest;
import com.evernote.android.job.patched.internal.JobStorageDatabaseErrorHandler;
import com.evernote.android.job.patched.internal.util.JobCat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

class JobStorage {
    private static final JobCat CAT = new JobCat("JobStorage");
    public static final String JOB_ID_COUNTER = "JOB_ID_COUNTER_v2";
    private static final String FAILED_DELETE_IDS = "FAILED_DELETE_IDS";
    public static final String PREF_FILE_NAME = "evernote_patched_jobs";
    public static final String DATABASE_NAME = "evernote_patched_jobs.db";
    public static final int DATABASE_VERSION = 6;
    public static final String JOB_TABLE_NAME = "jobs";
    public static final String COLUMN_ID = "_id";
    public static final String COLUMN_TAG = "tag";
    public static final String COLUMN_START_MS = "startMs";
    public static final String COLUMN_END_MS = "endMs";
    public static final String COLUMN_BACKOFF_MS = "backoffMs";
    public static final String COLUMN_BACKOFF_POLICY = "backoffPolicy";
    public static final String COLUMN_INTERVAL_MS = "intervalMs";
    public static final String COLUMN_REQUIREMENTS_ENFORCED = "requirementsEnforced";
    public static final String COLUMN_REQUIRES_CHARGING = "requiresCharging";
    public static final String COLUMN_REQUIRES_DEVICE_IDLE = "requiresDeviceIdle";
    public static final String COLUMN_EXACT = "exact";
    public static final String COLUMN_NETWORK_TYPE = "networkType";
    public static final String COLUMN_EXTRAS = "extras";
    @Deprecated
    private static final String COLUMN_PERSISTED = "persisted";
    public static final String COLUMN_NUM_FAILURES = "numFailures";
    public static final String COLUMN_SCHEDULED_AT = "scheduledAt";
    @Deprecated
    private static final String COLUMN_TRANSIENT_OLD = "isTransient";
    public static final String COLUMN_STARTED = "started";
    public static final String COLUMN_FLEX_MS = "flexMs";
    public static final String COLUMN_FLEX_SUPPORT = "flexSupport";
    public static final String COLUMN_LAST_RUN = "lastRun";
    public static final String COLUMN_TRANSIENT = "transient";
    public static final String COLUMN_REQUIRES_BATTERY_NOT_LOW = "requiresBatteryNotLow";
    public static final String COLUMN_REQUIRES_STORAGE_NOT_LOW = "requiresStorageNotLow";
    private static final int CACHE_SIZE = 30;
    private static final String WHERE_NOT_STARTED = "ifnull(started, 0)<=0";
    private final SharedPreferences mPreferences;
    private final JobCacheId mCacheId;
    private AtomicInteger mJobCounter;
    private final Set<String> mFailedDeleteIds;
    private final JobOpenHelper mDbHelper;
    private SQLiteDatabase mInjectedDatabase;
    private final ReadWriteLock mLock;

    public JobStorage(Context context) {
        this(context, DATABASE_NAME);
    }

    public JobStorage(Context context, String databasePath) {
        this.mPreferences = context.getSharedPreferences(PREF_FILE_NAME, 0);
        this.mLock = new ReentrantReadWriteLock();
        this.mCacheId = new JobCacheId();
        this.mDbHelper = new JobOpenHelper(context, databasePath);
        this.mFailedDeleteIds = this.mPreferences.getStringSet(FAILED_DELETE_IDS, new HashSet());
        if (!this.mFailedDeleteIds.isEmpty()) {
            this.tryToCleanupFinishedJobs();
        }
    }

    public void put(JobRequest request) {
        this.mLock.writeLock().lock();
        try {
            this.store(request);
            this.updateRequestInCache(request);
        }
        finally {
            this.mLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(JobRequest request, ContentValues contentValues) {
        SQLiteDatabase database = null;
        this.mLock.writeLock().lock();
        try {
            this.updateRequestInCache(request);
            database = this.getDatabase();
            database.update(JOB_TABLE_NAME, contentValues, "_id=?", new String[]{String.valueOf(request.getJobId())});
        }
        catch (Exception e) {
            try {
                CAT.e(e, "could not update %s", request);
            }
            catch (Throwable throwable) {
                JobStorage.closeDatabase(database);
                this.mLock.writeLock().unlock();
                throw throwable;
            }
            JobStorage.closeDatabase(database);
            this.mLock.writeLock().unlock();
        }
        JobStorage.closeDatabase(database);
        this.mLock.writeLock().unlock();
    }

    private void updateRequestInCache(JobRequest request) {
        this.mCacheId.put(request.getJobId(), request);
    }

    public JobRequest get(int id) {
        this.mLock.readLock().lock();
        try {
            JobRequest jobRequest = (JobRequest)this.mCacheId.get(id);
            return jobRequest;
        }
        finally {
            this.mLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<JobRequest> getAllJobRequests(@Nullable String tag, boolean includeStarted) {
        HashSet<JobRequest> result = new HashSet<JobRequest>();
        SQLiteDatabase database = null;
        Cursor cursor = null;
        this.mLock.readLock().lock();
        try {
            String[] args;
            String where;
            if (TextUtils.isEmpty((CharSequence)tag)) {
                where = includeStarted ? null : WHERE_NOT_STARTED;
                args = null;
            } else {
                where = includeStarted ? "" : "ifnull(started, 0)<=0 AND ";
                where = where + "tag=?";
                args = new String[]{tag};
            }
            database = this.getDatabase();
            cursor = database.query(JOB_TABLE_NAME, null, where, args, null, null, null);
            HashMap cachedRequests = new HashMap(this.mCacheId.snapshot());
            while (cursor != null && cursor.moveToNext()) {
                Integer id = cursor.getInt(cursor.getColumnIndex(COLUMN_ID));
                if (this.didFailToDelete(id)) continue;
                if (cachedRequests.containsKey(id)) {
                    result.add((JobRequest)cachedRequests.get(id));
                    continue;
                }
                result.add(JobRequest.fromCursor(cursor));
            }
        }
        catch (Exception e) {
            try {
                CAT.e(e, "could not load all jobs", new Object[0]);
            }
            catch (Throwable throwable) {
                JobStorage.closeCursor(cursor);
                JobStorage.closeDatabase(database);
                this.mLock.readLock().unlock();
                throw throwable;
            }
            JobStorage.closeCursor(cursor);
            JobStorage.closeDatabase(database);
            this.mLock.readLock().unlock();
        }
        JobStorage.closeCursor(cursor);
        JobStorage.closeDatabase(database);
        this.mLock.readLock().unlock();
        return result;
    }

    public void remove(JobRequest request) {
        this.remove(request, request.getJobId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean remove(@Nullable JobRequest request, int jobId) {
        boolean bl;
        SQLiteDatabase database = null;
        this.mLock.writeLock().lock();
        try {
            this.mCacheId.remove(jobId);
            database = this.getDatabase();
            database.delete(JOB_TABLE_NAME, "_id=?", new String[]{String.valueOf(jobId)});
            bl = true;
        }
        catch (Exception e) {
            boolean bl2;
            try {
                CAT.e(e, "could not delete %d %s", jobId, request);
                this.addFailedDeleteId(jobId);
                bl2 = false;
            }
            catch (Throwable throwable) {
                JobStorage.closeDatabase(database);
                this.mLock.writeLock().unlock();
                throw throwable;
            }
            JobStorage.closeDatabase(database);
            this.mLock.writeLock().unlock();
            return bl2;
        }
        JobStorage.closeDatabase(database);
        this.mLock.writeLock().unlock();
        return bl;
    }

    public synchronized int nextJobId() {
        int offset;
        int id;
        if (this.mJobCounter == null) {
            this.mJobCounter = new AtomicInteger(this.getMaxJobId());
        }
        if ((id = this.mJobCounter.incrementAndGet()) < (offset = JobConfig.getJobIdOffset()) || id >= 2147480000) {
            this.mJobCounter.set(offset);
            id = this.mJobCounter.incrementAndGet();
        }
        this.mPreferences.edit().putInt(JOB_ID_COUNTER, id).apply();
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void store(JobRequest request) {
        ContentValues contentValues = request.toContentValues();
        SQLiteDatabase database = null;
        try {
            database = this.getDatabase();
            if (database.insertWithOnConflict(JOB_TABLE_NAME, null, contentValues, 5) < 0L) {
                throw new SQLException("Couldn't insert job request into database");
            }
        }
        finally {
            JobStorage.closeDatabase(database);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JobRequest load(int id, boolean includeStarted) {
        Cursor cursor;
        SQLiteDatabase database;
        block6: {
            JobRequest jobRequest;
            if (this.didFailToDelete(id)) {
                return null;
            }
            database = null;
            cursor = null;
            try {
                String where = "_id=?";
                if (!includeStarted) {
                    where = where + " AND started<=0";
                }
                if ((cursor = (database = this.getDatabase()).query(JOB_TABLE_NAME, null, where, new String[]{String.valueOf(id)}, null, null, null)) == null || !cursor.moveToFirst()) break block6;
                jobRequest = JobRequest.fromCursor(cursor);
            }
            catch (Exception e) {
                try {
                    CAT.e(e, "could not load id %d", id);
                }
                catch (Throwable throwable) {
                    JobStorage.closeCursor(cursor);
                    JobStorage.closeDatabase(database);
                    throw throwable;
                }
                JobStorage.closeCursor(cursor);
                JobStorage.closeDatabase(database);
            }
            JobStorage.closeCursor(cursor);
            JobStorage.closeDatabase(database);
            return jobRequest;
        }
        JobStorage.closeCursor(cursor);
        JobStorage.closeDatabase(database);
        return null;
    }

    @NonNull
    @VisibleForTesting
    SQLiteDatabase getDatabase() {
        if (this.mInjectedDatabase != null) {
            return this.mInjectedDatabase;
        }
        try {
            return this.mDbHelper.getWritableDatabase();
        }
        catch (SQLiteCantOpenDatabaseException e) {
            CAT.e(e);
            new JobStorageDatabaseErrorHandler().deleteDatabaseFile(DATABASE_NAME);
            return this.mDbHelper.getWritableDatabase();
        }
    }

    @VisibleForTesting
    void injectDatabase(SQLiteDatabase database) {
        this.mInjectedDatabase = database;
    }

    @VisibleForTesting
    Set<String> getFailedDeleteIds() {
        return this.mFailedDeleteIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    int getMaxJobId() {
        int jobId;
        Cursor cursor;
        SQLiteDatabase database;
        block4: {
            database = null;
            cursor = null;
            jobId = 0;
            try {
                database = this.getDatabase();
                cursor = database.rawQuery("SELECT MAX(_id) FROM jobs", null);
                if (cursor == null || !cursor.moveToFirst()) break block4;
                jobId = cursor.getInt(0);
            }
            catch (Exception e) {
                try {
                    CAT.e(e);
                }
                catch (Throwable throwable) {
                    JobStorage.closeCursor(cursor);
                    JobStorage.closeDatabase(database);
                    throw throwable;
                }
                JobStorage.closeCursor(cursor);
                JobStorage.closeDatabase(database);
            }
        }
        JobStorage.closeCursor(cursor);
        JobStorage.closeDatabase(database);
        return Math.max(JobConfig.getJobIdOffset(), Math.max(jobId, this.mPreferences.getInt(JOB_ID_COUNTER, 0)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addFailedDeleteId(int id) {
        Set<String> set = this.mFailedDeleteIds;
        synchronized (set) {
            this.mFailedDeleteIds.add(String.valueOf(id));
            this.mPreferences.edit().putStringSet(FAILED_DELETE_IDS, this.mFailedDeleteIds).apply();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean didFailToDelete(int id) {
        Set<String> set = this.mFailedDeleteIds;
        synchronized (set) {
            return !this.mFailedDeleteIds.isEmpty() && this.mFailedDeleteIds.contains(String.valueOf(id));
        }
    }

    private void tryToCleanupFinishedJobs() {
        new Thread("CleanupFinishedJobsThread"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                HashSet ids;
                Set set = JobStorage.this.mFailedDeleteIds;
                synchronized (set) {
                    ids = new HashSet(JobStorage.this.mFailedDeleteIds);
                }
                Iterator iterator = ids.iterator();
                while (iterator.hasNext()) {
                    String idString = (String)iterator.next();
                    try {
                        int jobId = Integer.parseInt(idString);
                        if (JobStorage.this.remove(null, jobId)) {
                            iterator.remove();
                            CAT.i("Deleted job %d which failed to delete earlier", jobId);
                            continue;
                        }
                        CAT.e("Couldn't delete job %d which failed to delete earlier", jobId);
                    }
                    catch (NumberFormatException e) {
                        iterator.remove();
                    }
                }
                Set set2 = JobStorage.this.mFailedDeleteIds;
                synchronized (set2) {
                    JobStorage.this.mFailedDeleteIds.clear();
                    if (ids.size() > 50) {
                        int counter = 0;
                        for (String id : ids) {
                            if (counter++ <= 50) {
                                JobStorage.this.mFailedDeleteIds.add(id);
                                continue;
                            }
                            break;
                        }
                    } else {
                        JobStorage.this.mFailedDeleteIds.addAll(ids);
                    }
                }
            }
        }.start();
    }

    private static void closeCursor(@Nullable Cursor cursor) {
        if (cursor != null) {
            try {
                cursor.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static void closeDatabase(@Nullable SQLiteDatabase database) {
        if (database != null && JobConfig.isCloseDatabase()) {
            try {
                database.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static final class JobOpenHelper
    extends SQLiteOpenHelper {
        private JobOpenHelper(Context context, String databasePath) {
            super(context, databasePath, null, 6, (DatabaseErrorHandler)new JobStorageDatabaseErrorHandler());
        }

        public void onCreate(SQLiteDatabase db) {
            this.createJobTable(db);
        }

        public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
            block7: while (oldVersion < newVersion) {
                switch (oldVersion) {
                    case 1: {
                        this.upgradeFrom1To2(db);
                        ++oldVersion;
                        continue block7;
                    }
                    case 2: {
                        this.upgradeFrom2To3(db);
                        ++oldVersion;
                        continue block7;
                    }
                    case 3: {
                        this.upgradeFrom3To4(db);
                        ++oldVersion;
                        continue block7;
                    }
                    case 4: {
                        this.upgradeFrom4To5(db);
                        ++oldVersion;
                        continue block7;
                    }
                    case 5: {
                        this.upgradeFrom5To6(db);
                        ++oldVersion;
                        continue block7;
                    }
                }
                throw new IllegalStateException("not implemented");
            }
        }

        private void createJobTable(SQLiteDatabase db) {
            db.execSQL("create table jobs (_id integer primary key, tag text not null, startMs integer, endMs integer, backoffMs integer, backoffPolicy text not null, intervalMs integer, requirementsEnforced integer, requiresCharging integer, requiresDeviceIdle integer, exact integer, networkType text not null, extras text, numFailures integer, scheduledAt integer, started integer, flexMs integer, flexSupport integer, lastRun integer, transient integer, requiresBatteryNotLow integer, requiresStorageNotLow integer);");
        }

        private void upgradeFrom1To2(SQLiteDatabase db) {
            db.execSQL("alter table jobs add column isTransient integer;");
        }

        private void upgradeFrom2To3(SQLiteDatabase db) {
            db.execSQL("alter table jobs add column flexMs integer;");
            db.execSQL("alter table jobs add column flexSupport integer;");
            ContentValues contentValues = new ContentValues();
            contentValues.put(JobStorage.COLUMN_INTERVAL_MS, Long.valueOf(JobRequest.MIN_INTERVAL));
            db.update(JobStorage.JOB_TABLE_NAME, contentValues, "intervalMs>0 AND intervalMs<" + JobRequest.MIN_INTERVAL, new String[0]);
            db.execSQL("update jobs set flexMs = intervalMs;");
        }

        private void upgradeFrom3To4(SQLiteDatabase db) {
            db.execSQL("alter table jobs add column lastRun integer;");
        }

        private void upgradeFrom4To5(SQLiteDatabase db) {
            try {
                db.beginTransaction();
                String newTable = "jobs_new";
                db.execSQL("create table " + newTable + " (" + JobStorage.COLUMN_ID + " integer primary key, " + JobStorage.COLUMN_TAG + " text not null, " + JobStorage.COLUMN_START_MS + " integer, " + JobStorage.COLUMN_END_MS + " integer, " + JobStorage.COLUMN_BACKOFF_MS + " integer, " + JobStorage.COLUMN_BACKOFF_POLICY + " text not null, " + JobStorage.COLUMN_INTERVAL_MS + " integer, " + JobStorage.COLUMN_REQUIREMENTS_ENFORCED + " integer, " + JobStorage.COLUMN_REQUIRES_CHARGING + " integer, " + JobStorage.COLUMN_REQUIRES_DEVICE_IDLE + " integer, " + JobStorage.COLUMN_EXACT + " integer, " + JobStorage.COLUMN_NETWORK_TYPE + " text not null, " + JobStorage.COLUMN_EXTRAS + " text, " + JobStorage.COLUMN_NUM_FAILURES + " integer, " + JobStorage.COLUMN_SCHEDULED_AT + " integer, " + JobStorage.COLUMN_STARTED + " integer, " + JobStorage.COLUMN_FLEX_MS + " integer, " + JobStorage.COLUMN_FLEX_SUPPORT + " integer, " + JobStorage.COLUMN_LAST_RUN + " integer);");
                db.execSQL("INSERT INTO " + newTable + " SELECT " + JobStorage.COLUMN_ID + "," + JobStorage.COLUMN_TAG + "," + JobStorage.COLUMN_START_MS + "," + JobStorage.COLUMN_END_MS + "," + JobStorage.COLUMN_BACKOFF_MS + "," + JobStorage.COLUMN_BACKOFF_POLICY + "," + JobStorage.COLUMN_INTERVAL_MS + "," + JobStorage.COLUMN_REQUIREMENTS_ENFORCED + "," + JobStorage.COLUMN_REQUIRES_CHARGING + "," + JobStorage.COLUMN_REQUIRES_DEVICE_IDLE + "," + JobStorage.COLUMN_EXACT + "," + JobStorage.COLUMN_NETWORK_TYPE + "," + JobStorage.COLUMN_EXTRAS + "," + JobStorage.COLUMN_NUM_FAILURES + "," + JobStorage.COLUMN_SCHEDULED_AT + "," + JobStorage.COLUMN_TRANSIENT_OLD + "," + JobStorage.COLUMN_FLEX_MS + "," + JobStorage.COLUMN_FLEX_SUPPORT + "," + JobStorage.COLUMN_LAST_RUN + " FROM " + JobStorage.JOB_TABLE_NAME);
                db.execSQL("DROP TABLE jobs");
                db.execSQL("ALTER TABLE " + newTable + " RENAME TO " + JobStorage.JOB_TABLE_NAME);
                db.execSQL("alter table jobs add column transient integer;");
                db.setTransactionSuccessful();
            }
            finally {
                db.endTransaction();
            }
        }

        private void upgradeFrom5To6(SQLiteDatabase db) {
            db.execSQL("alter table jobs add column requiresBatteryNotLow integer;");
            db.execSQL("alter table jobs add column requiresStorageNotLow integer;");
        }
    }

    private class JobCacheId
    extends LruCache<Integer, JobRequest> {
        public JobCacheId() {
            super(30);
        }

        protected JobRequest create(Integer id) {
            return JobStorage.this.load(id, true);
        }
    }
}

