/*
 * Decompiled with CFR 0.152.
 */
package com.evernote.android.job.patched.internal.v14;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import androidx.annotation.Nullable;
import com.evernote.android.job.patched.internal.JobProxy;
import com.evernote.android.job.patched.internal.v14.PlatformAlarmService;
import com.evernote.android.job.patched.internal.v14.PlatformAlarmServiceExact;

public class PlatformAlarmReceiver
extends BroadcastReceiver {
    static final String EXTRA_JOB_ID = "EXTRA_JOB_ID";
    static final String EXTRA_JOB_EXACT = "EXTRA_JOB_EXACT";
    static final String EXTRA_TRANSIENT_EXTRAS = "EXTRA_TRANSIENT_EXTRAS";

    static Intent createIntent(Context context, int jobId, boolean exact, @Nullable Bundle transientExtras) {
        Intent intent = new Intent(context, PlatformAlarmReceiver.class).putExtra(EXTRA_JOB_ID, jobId).putExtra(EXTRA_JOB_EXACT, exact);
        if (transientExtras != null) {
            intent.putExtra(EXTRA_TRANSIENT_EXTRAS, transientExtras);
        }
        return intent;
    }

    public void onReceive(Context context, Intent intent) {
        if (intent != null && intent.hasExtra(EXTRA_JOB_ID) && intent.hasExtra(EXTRA_JOB_EXACT)) {
            int jobId = intent.getIntExtra(EXTRA_JOB_ID, -1);
            Bundle transientExtras = intent.getBundleExtra(EXTRA_TRANSIENT_EXTRAS);
            if (intent.getBooleanExtra(EXTRA_JOB_EXACT, false)) {
                Intent serviceIntent = PlatformAlarmServiceExact.createIntent(context, jobId, transientExtras);
                JobProxy.Common.startWakefulService(context, serviceIntent);
            } else {
                PlatformAlarmService.start(context, jobId, transientExtras);
            }
        }
    }
}

