/*
 * Decompiled with CFR 0.152.
 */
package com.evernote.android.job.patched.internal.v21;

import android.annotation.TargetApi;
import android.app.AlarmManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.evernote.android.job.patched.internal.JobRequest;
import com.evernote.android.job.patched.internal.util.JobCat;
import com.evernote.android.job.patched.internal.v14.PlatformAlarmServiceExact;
import java.util.concurrent.TimeUnit;

@TargetApi(value=21)
final class TransientBundleCompat {
    private static final JobCat CAT = new JobCat("TransientBundleCompat");

    private TransientBundleCompat() {
        throw new UnsupportedOperationException();
    }

    public static void persistBundle(@NonNull Context context, @NonNull JobRequest request) {
        Intent intent = PlatformAlarmServiceExact.createIntent(context, request.getJobId(), request.getTransientExtras());
        PendingIntent pendingIntent = PendingIntent.getService((Context)context, (int)request.getJobId(), (Intent)intent, (int)TransientBundleCompat.addImmutableFlag(0x8000000));
        long when = System.currentTimeMillis() + TimeUnit.DAYS.toMillis(1000L);
        AlarmManager alarmManager = (AlarmManager)context.getSystemService("alarm");
        alarmManager.setExact(1, when, pendingIntent);
    }

    public static boolean startWithTransientBundle(@NonNull Context context, @NonNull JobRequest request) {
        Intent intent = PlatformAlarmServiceExact.createIntent(context, request.getJobId(), null);
        PendingIntent pendingIntent = PendingIntent.getService((Context)context, (int)request.getJobId(), (Intent)intent, (int)TransientBundleCompat.addImmutableFlag(0x20000000));
        if (pendingIntent == null) {
            return false;
        }
        try {
            CAT.i("Delegating transient job %s to API 14", request);
            pendingIntent.send();
        }
        catch (PendingIntent.CanceledException e) {
            CAT.e(e);
            return false;
        }
        if (!request.isPeriodic()) {
            TransientBundleCompat.cancel(context, request.getJobId(), pendingIntent);
        }
        return true;
    }

    public static boolean isScheduled(Context context, int jobId) {
        Intent intent = PlatformAlarmServiceExact.createIntent(context, jobId, null);
        return PendingIntent.getService((Context)context, (int)jobId, (Intent)intent, (int)TransientBundleCompat.addImmutableFlag(0x20000000)) != null;
    }

    public static void cancel(@NonNull Context context, int jobId, @Nullable PendingIntent pendingIntent) {
        try {
            Intent intent;
            if (pendingIntent == null && (pendingIntent = PendingIntent.getService((Context)context, (int)jobId, (Intent)(intent = PlatformAlarmServiceExact.createIntent(context, jobId, null)), (int)TransientBundleCompat.addImmutableFlag(0x20000000))) == null) {
                return;
            }
            AlarmManager alarmManager = (AlarmManager)context.getSystemService("alarm");
            alarmManager.cancel(pendingIntent);
            pendingIntent.cancel();
        }
        catch (Exception e) {
            CAT.e(e);
        }
    }

    private static int addImmutableFlag(int flags) {
        if (Build.VERSION.SDK_INT >= 23) {
            flags |= 0x4000000;
        }
        return flags;
    }
}

