/*
 * Decompiled with CFR 0.152.
 */
package com.yandex.mapkit;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.yandex.mapkit.Attribution;
import com.yandex.mapkit.Image;
import com.yandex.mapkit.geometry.Direction;
import com.yandex.mapkit.geometry.Point;
import com.yandex.runtime.NativeObject;
import com.yandex.runtime.bindings.Archive;
import com.yandex.runtime.bindings.Serializable;
import java.nio.ByteBuffer;

public class GeoPhoto
implements Serializable {
    private Image image;
    private boolean image__is_initialized = false;
    private ShootingPoint shootingPoint;
    private boolean shootingPoint__is_initialized = false;
    private Long takenAt;
    private boolean takenAt__is_initialized = false;
    private Attribution attribution;
    private boolean attribution__is_initialized = false;
    private NativeObject nativeObject;

    public GeoPhoto() {
    }

    public GeoPhoto(@NonNull Image image, @Nullable ShootingPoint shootingPoint, @Nullable Long takenAt, @Nullable Attribution attribution) {
        if (image == null) {
            throw new IllegalArgumentException("Required field \"image\" cannot be null");
        }
        this.nativeObject = this.init(image, shootingPoint, takenAt, attribution);
        this.image = image;
        this.image__is_initialized = true;
        this.shootingPoint = shootingPoint;
        this.shootingPoint__is_initialized = true;
        this.takenAt = takenAt;
        this.takenAt__is_initialized = true;
        this.attribution = attribution;
        this.attribution__is_initialized = true;
    }

    private native NativeObject init(Image var1, ShootingPoint var2, Long var3, Attribution var4);

    private GeoPhoto(NativeObject nativeObject) {
        this.nativeObject = nativeObject;
    }

    @NonNull
    public synchronized Image getImage() {
        if (!this.image__is_initialized) {
            this.image = this.getImage__Native();
            this.image__is_initialized = true;
        }
        return this.image;
    }

    private native Image getImage__Native();

    @Nullable
    public synchronized ShootingPoint getShootingPoint() {
        if (!this.shootingPoint__is_initialized) {
            this.shootingPoint = this.getShootingPoint__Native();
            this.shootingPoint__is_initialized = true;
        }
        return this.shootingPoint;
    }

    private native ShootingPoint getShootingPoint__Native();

    @Nullable
    public synchronized Long getTakenAt() {
        if (!this.takenAt__is_initialized) {
            this.takenAt = this.getTakenAt__Native();
            this.takenAt__is_initialized = true;
        }
        return this.takenAt;
    }

    private native Long getTakenAt__Native();

    @Nullable
    public synchronized Attribution getAttribution() {
        if (!this.attribution__is_initialized) {
            this.attribution = this.getAttribution__Native();
            this.attribution__is_initialized = true;
        }
        return this.attribution;
    }

    private native Attribution getAttribution__Native();

    @Override
    public void serialize(Archive archive) {
        if (archive.isReader()) {
            ByteBuffer buffer = null;
            buffer = archive.add(buffer);
            this.nativeObject = GeoPhoto.loadNative(buffer);
        } else {
            ByteBuffer buffer = ByteBuffer.allocateDirect(10);
            archive.add(this.saveNative());
        }
    }

    private static native NativeObject loadNative(ByteBuffer var0);

    private native ByteBuffer saveNative();

    public static String getNativeName() {
        return "yandex::maps::mapkit::GeoPhoto";
    }

    public static class ShootingPoint
    implements Serializable {
        private Point3D point;
        private Direction direction;

        public ShootingPoint(@NonNull Point3D point, @Nullable Direction direction) {
            if (point == null) {
                throw new IllegalArgumentException("Required field \"point\" cannot be null");
            }
            this.point = point;
            this.direction = direction;
        }

        public ShootingPoint() {
        }

        @NonNull
        public Point3D getPoint() {
            return this.point;
        }

        @Nullable
        public Direction getDirection() {
            return this.direction;
        }

        @Override
        public void serialize(Archive archive) {
            this.point = archive.add(this.point, false, Point3D.class);
            this.direction = archive.add(this.direction, true, Direction.class);
        }
    }

    public static class Point3D
    implements Serializable {
        private Point point;
        private Double altitude;

        public Point3D(@NonNull Point point, @Nullable Double altitude) {
            if (point == null) {
                throw new IllegalArgumentException("Required field \"point\" cannot be null");
            }
            this.point = point;
            this.altitude = altitude;
        }

        public Point3D() {
        }

        @NonNull
        public Point getPoint() {
            return this.point;
        }

        @Nullable
        public Double getAltitude() {
            return this.altitude;
        }

        @Override
        public void serialize(Archive archive) {
            this.point = archive.add(this.point, false, Point.class);
            this.altitude = archive.add(this.altitude, true);
        }
    }
}

