/*
 * Decompiled with CFR 0.152.
 */
package com.yandex.mapkit;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.yandex.mapkit.MapKit;
import com.yandex.mapkit.offline_cache.internal.BackgroundDownloadManager;
import com.yandex.runtime.Runtime;
import com.yandex.runtime.i18n.I18nManagerFactory;

public final class MapKitFactory {
    private static String apiKey_ = null;
    private static String locale_ = null;
    private static boolean initialized_ = false;

    public static synchronized void initialize(Context context) {
        MapKitFactory.checkApiKey();
        Runtime.init(context);
        I18nManagerFactory.setLocale(locale_);
        MapKitFactory.getInstance().setApiKey(apiKey_);
        initialized_ = true;
    }

    public static synchronized void setApiKey(@NonNull String apiKey) {
        assert (!initialized_) : "setApiKey() should be called before initialize()!";
        apiKey_ = apiKey;
    }

    public static synchronized void setLocale(@Nullable String locale) {
        assert (!initialized_) : "setLocale() should be called before initialize()!";
        locale_ = locale;
    }

    public static synchronized void initializeBackgroundDownload(Context context, final Runnable mapkitInitializer) {
        MapKitFactory.checkApiKey();
        BackgroundDownloadManager.initialize(new Runnable(){

            @Override
            public void run() {
                mapkitInitializer.run();
                MapKitFactory.getInstance().getOfflineCacheManager();
            }
        }, context);
    }

    public static native MapKit getInstance();

    private static void checkApiKey() {
        assert (apiKey_ != null && !apiKey_.isEmpty()) : "You need to set the API key before using MapKit!";
    }
}

