/*
 * Decompiled with CFR 0.152.
 */
package com.yandex.mapkit.geometry;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.yandex.mapkit.geometry.BoundingBox;
import com.yandex.mapkit.geometry.Circle;
import com.yandex.mapkit.geometry.MultiPolygon;
import com.yandex.mapkit.geometry.Point;
import com.yandex.mapkit.geometry.Polygon;
import com.yandex.mapkit.geometry.Polyline;

public class Geometry {
    private Point point;
    private Polyline polyline;
    private Polygon polygon;
    private MultiPolygon multiPolygon;
    private BoundingBox boundingBox;
    private Circle circle;

    @NonNull
    public static Geometry fromPoint(@NonNull Point point) {
        if (point == null) {
            throw new IllegalArgumentException("Variant value \"point\" cannot be null");
        }
        Geometry geometry = new Geometry();
        geometry.point = point;
        return geometry;
    }

    @NonNull
    public static Geometry fromPolyline(@NonNull Polyline polyline) {
        if (polyline == null) {
            throw new IllegalArgumentException("Variant value \"polyline\" cannot be null");
        }
        Geometry geometry = new Geometry();
        geometry.polyline = polyline;
        return geometry;
    }

    @NonNull
    public static Geometry fromPolygon(@NonNull Polygon polygon) {
        if (polygon == null) {
            throw new IllegalArgumentException("Variant value \"polygon\" cannot be null");
        }
        Geometry geometry = new Geometry();
        geometry.polygon = polygon;
        return geometry;
    }

    @NonNull
    public static Geometry fromMultiPolygon(@NonNull MultiPolygon multiPolygon) {
        if (multiPolygon == null) {
            throw new IllegalArgumentException("Variant value \"multiPolygon\" cannot be null");
        }
        Geometry geometry = new Geometry();
        geometry.multiPolygon = multiPolygon;
        return geometry;
    }

    @NonNull
    public static Geometry fromBoundingBox(@NonNull BoundingBox boundingBox) {
        if (boundingBox == null) {
            throw new IllegalArgumentException("Variant value \"boundingBox\" cannot be null");
        }
        Geometry geometry = new Geometry();
        geometry.boundingBox = boundingBox;
        return geometry;
    }

    @NonNull
    public static Geometry fromCircle(@NonNull Circle circle) {
        if (circle == null) {
            throw new IllegalArgumentException("Variant value \"circle\" cannot be null");
        }
        Geometry geometry = new Geometry();
        geometry.circle = circle;
        return geometry;
    }

    @Nullable
    public Point getPoint() {
        return this.point;
    }

    @Nullable
    public Polyline getPolyline() {
        return this.polyline;
    }

    @Nullable
    public Polygon getPolygon() {
        return this.polygon;
    }

    @Nullable
    public MultiPolygon getMultiPolygon() {
        return this.multiPolygon;
    }

    @Nullable
    public BoundingBox getBoundingBox() {
        return this.boundingBox;
    }

    @Nullable
    public Circle getCircle() {
        return this.circle;
    }
}

