/*
 * Decompiled with CFR 0.152.
 */
package com.yandex.mapkit.layers;

import androidx.annotation.NonNull;
import com.yandex.mapkit.layers.OverzoomMode;
import com.yandex.runtime.bindings.Archive;
import com.yandex.runtime.bindings.Serializable;

public final class LayerOptions
implements Serializable {
    private boolean active = true;
    private boolean nightModeAvailable = true;
    private boolean cacheable = false;
    private boolean animateOnActivation = false;
    private long tileAppearingAnimationDuration = 400L;
    private OverzoomMode overzoomMode = OverzoomMode.DISABLED;
    private boolean transparent = false;

    public LayerOptions(boolean active, boolean nightModeAvailable, boolean cacheable, boolean animateOnActivation, long tileAppearingAnimationDuration, @NonNull OverzoomMode overzoomMode, boolean transparent) {
        if (overzoomMode == null) {
            throw new IllegalArgumentException("Required field \"overzoomMode\" cannot be null");
        }
        this.active = active;
        this.nightModeAvailable = nightModeAvailable;
        this.cacheable = cacheable;
        this.animateOnActivation = animateOnActivation;
        this.tileAppearingAnimationDuration = tileAppearingAnimationDuration;
        this.overzoomMode = overzoomMode;
        this.transparent = transparent;
    }

    public LayerOptions() {
    }

    public boolean getActive() {
        return this.active;
    }

    public LayerOptions setActive(boolean active) {
        this.active = active;
        return this;
    }

    public boolean getNightModeAvailable() {
        return this.nightModeAvailable;
    }

    public LayerOptions setNightModeAvailable(boolean nightModeAvailable) {
        this.nightModeAvailable = nightModeAvailable;
        return this;
    }

    public boolean getCacheable() {
        return this.cacheable;
    }

    public LayerOptions setCacheable(boolean cacheable) {
        this.cacheable = cacheable;
        return this;
    }

    public boolean getAnimateOnActivation() {
        return this.animateOnActivation;
    }

    public LayerOptions setAnimateOnActivation(boolean animateOnActivation) {
        this.animateOnActivation = animateOnActivation;
        return this;
    }

    public long getTileAppearingAnimationDuration() {
        return this.tileAppearingAnimationDuration;
    }

    public LayerOptions setTileAppearingAnimationDuration(long tileAppearingAnimationDuration) {
        this.tileAppearingAnimationDuration = tileAppearingAnimationDuration;
        return this;
    }

    @NonNull
    public OverzoomMode getOverzoomMode() {
        return this.overzoomMode;
    }

    public LayerOptions setOverzoomMode(@NonNull OverzoomMode overzoomMode) {
        if (overzoomMode == null) {
            throw new IllegalArgumentException("Required field \"overzoomMode\" cannot be null");
        }
        this.overzoomMode = overzoomMode;
        return this;
    }

    public boolean getTransparent() {
        return this.transparent;
    }

    public LayerOptions setTransparent(boolean transparent) {
        this.transparent = transparent;
        return this;
    }

    @Override
    public void serialize(Archive archive) {
        this.active = archive.add(this.active);
        this.nightModeAvailable = archive.add(this.nightModeAvailable);
        this.cacheable = archive.add(this.cacheable);
        this.animateOnActivation = archive.add(this.animateOnActivation);
        this.tileAppearingAnimationDuration = archive.add(this.tileAppearingAnimationDuration);
        this.overzoomMode = archive.add(this.overzoomMode, false, OverzoomMode.class);
        this.transparent = archive.add(this.transparent);
    }
}

