/*
 * Decompiled with CFR 0.152.
 */
package com.yandex.mapkit.mapview;

import android.content.Context;
import android.graphics.Rect;
import android.opengl.GLSurfaceView;
import android.view.Surface;
import androidx.annotation.NonNull;
import androidx.car.app.SurfaceCallback;
import androidx.car.app.SurfaceContainer;
import com.yandex.mapkit.MapKitFactory;
import com.yandex.mapkit.map.Map;
import com.yandex.mapkit.map.MapWindow;
import com.yandex.runtime.view.PlatformGLSurface;

public class MapSurface
implements SurfaceCallback {
    private final PlatformGLSurface platformGLSurface;
    private final MapWindow mapWindow;
    private Surface surface = null;

    public MapSurface(Context context) {
        this(context, null);
    }

    public MapSurface(Context context, GLSurfaceView.Renderer overlayRenderer) {
        this(context, overlayRenderer, null);
    }

    public MapSurface(Context context, GLSurfaceView.Renderer overlayRenderer, Float scaleFactor) {
        this.platformGLSurface = new PlatformGLSurface(context, false, overlayRenderer);
        this.mapWindow = scaleFactor == null ? MapKitFactory.getInstance().createMapWindow(this.platformGLSurface) : MapKitFactory.getInstance().createMapWindow(this.platformGLSurface, scaleFactor.floatValue());
    }

    public void onSurfaceAvailable(@NonNull SurfaceContainer surfaceContainer) {
        this.surface = surfaceContainer.getSurface();
        if (this.isSurfaceValid()) {
            this.platformGLSurface.onSurfaceAvailable(this.surface, surfaceContainer.getWidth(), surfaceContainer.getHeight());
            this.platformGLSurface.start();
            this.platformGLSurface.resume();
        }
    }

    public void onVisibleAreaChanged(@NonNull Rect visibleArea) {
    }

    public void onStableAreaChanged(@NonNull Rect stableArea) {
    }

    public void onSurfaceDestroyed(@NonNull SurfaceContainer surfaceContainer) {
        if (this.surface == null) {
            return;
        }
        this.platformGLSurface.pause();
        this.platformGLSurface.stop();
        this.platformGLSurface.onSurfaceDestroyed(surfaceContainer.getSurface());
        this.surface = null;
    }

    public boolean isSurfaceValid() {
        return this.surface != null && this.surface.isValid();
    }

    public MapWindow getMapWindow() {
        return this.mapWindow;
    }

    public Map getMap() {
        return this.mapWindow.getMap();
    }

    public void requestRender() {
        if (this.isSurfaceValid()) {
            this.platformGLSurface.requestRenderNative();
        }
    }

    public void destroyNativePlatformView() {
        this.platformGLSurface.destroyNativePlatformView();
    }
}

