/*
 * Decompiled with CFR 0.152.
 */
package com.yandex.mapkit.mapview;

import android.content.Context;
import android.graphics.SurfaceTexture;
import android.view.MotionEvent;
import com.yandex.mapkit.MapKitFactory;
import com.yandex.mapkit.ScreenPoint;
import com.yandex.mapkit.ScreenRect;
import com.yandex.mapkit.geometry.Point;
import com.yandex.mapkit.map.GestureFocusPointMode;
import com.yandex.mapkit.map.Map;
import com.yandex.mapkit.map.MapWindow;
import com.yandex.mapkit.map.PointOfView;
import com.yandex.mapkit.map.SizeChangedListener;
import com.yandex.mapkit.map.VisibleRegion;
import com.yandex.mapkit.map.internal.MapWindowBinding;
import com.yandex.runtime.view.GraphicsAPIType;
import com.yandex.runtime.view.PlatformGLSurfaceTextureView;

public class MapTexture {
    private PlatformGLSurfaceTextureView platformGLView;
    private MapWindowBinding mapWindow;

    public MapTexture(Context context) {
        this(context, false);
    }

    public MapTexture(Context context, int width, int height) {
        this(context, width, height, false);
    }

    public MapTexture(Context context, int width, int height, boolean debugModeEnabled) {
        MapKitFactory.initialize(context);
        this.platformGLView = new PlatformGLSurfaceTextureView(context, width, height, debugModeEnabled);
        this.mapWindow = (MapWindowBinding)MapKitFactory.getInstance().createMapWindow(this.platformGLView);
    }

    public MapTexture(Context context, boolean debugModeEnabled) {
        MapKitFactory.initialize(context);
        this.platformGLView = new PlatformGLSurfaceTextureView(context, debugModeEnabled);
        this.mapWindow = (MapWindowBinding)MapKitFactory.getInstance().createMapWindow(this.platformGLView);
    }

    public void setTexture(SurfaceTexture surfaceTexture, int width, int height) {
        this.platformGLView.setTexture(surfaceTexture, width, height);
    }

    public void removeTexture() {
        this.platformGLView.onTextureDestroyed();
    }

    public void onTextureSizeChanged(int width, int height) {
        this.platformGLView.onSizeChanged(width, height);
    }

    public boolean onTouchEvent(MotionEvent event) {
        return this.platformGLView.onTouchEvent(event);
    }

    public int width() {
        return this.mapWindow.width();
    }

    public int height() {
        return this.mapWindow.height();
    }

    public float getScaleFactor() {
        return this.mapWindow.getScaleFactor();
    }

    public void setScaleFactor(float scaleFactor) {
        this.mapWindow.setScaleFactor(scaleFactor);
    }

    public void startPerformanceMetricsCapture() {
        this.mapWindow.startPerformanceMetricsCapture();
    }

    public String stopPerformanceMetricsCapture() {
        return this.mapWindow.stopPerformanceMetricsCapture();
    }

    public void setMaxFps(float fps) {
        this.mapWindow.setMaxFps(fps);
    }

    public Map getMap() {
        return this.mapWindow.getMap();
    }

    public ScreenPoint worldToScreen(Point worldPoint) {
        return this.mapWindow.worldToScreen(worldPoint);
    }

    public Point screenToWorld(ScreenPoint screenPoint) {
        return this.mapWindow.screenToWorld(screenPoint);
    }

    public ScreenRect getFocusRect() {
        return this.mapWindow.getFocusRect();
    }

    public void setFocusRect(ScreenRect rect) {
        this.mapWindow.setFocusRect(rect);
    }

    public ScreenPoint getFocusPoint() {
        return this.mapWindow.getFocusPoint();
    }

    public void setFocusPoint(ScreenPoint point) {
        this.mapWindow.setFocusPoint(point);
    }

    public ScreenPoint getGestureFocusPoint() {
        return this.mapWindow.getGestureFocusPoint();
    }

    public void setGestureFocusPoint(ScreenPoint gestureFocusPoint) {
        this.mapWindow.setGestureFocusPoint(gestureFocusPoint);
    }

    public GestureFocusPointMode getGestureFocusPointMode() {
        return this.mapWindow.getGestureFocusPointMode();
    }

    public void setGestureFocusPointMode(GestureFocusPointMode gestureFocusPoint) {
        this.mapWindow.setGestureFocusPointMode(gestureFocusPoint);
    }

    public PointOfView getPointOfView() {
        return this.mapWindow.getPointOfView();
    }

    public void setPointOfView(PointOfView pointOfView) {
        this.mapWindow.setPointOfView(pointOfView);
    }

    public double getFieldOfViewY() {
        return this.mapWindow.getFieldOfViewY();
    }

    public void setFieldOfViewY(double fovY) {
        this.mapWindow.setFieldOfViewY(fovY);
    }

    public VisibleRegion getFocusRegion() {
        return this.mapWindow.getFocusRegion();
    }

    public void addSizeChangedListener(SizeChangedListener listener) {
        this.mapWindow.addSizeChangedListener(listener);
    }

    public void removeSizeChangedListener(SizeChangedListener listener) {
        this.mapWindow.removeSizeChangedListener(listener);
    }

    public void setNoninteractive(boolean is) {
        this.platformGLView.setNoninteractive(is);
    }

    public boolean isValid() {
        return this.mapWindow.isValid();
    }

    public void onStop() {
        this.platformGLView.pause();
        this.platformGLView.stop();
    }

    public void onStart() {
        this.platformGLView.start();
        this.platformGLView.resume();
    }

    public void onMemoryWarning() {
        this.platformGLView.onMemoryWarning();
    }

    public MapWindow getMapWindow() {
        return this.mapWindow;
    }

    public GraphicsAPIType getGraphicsAPI() {
        return GraphicsAPIType.OPEN_GL;
    }
}

