/*
 * Decompiled with CFR 0.152.
 */
package com.yandex.mapkit.mapview;

import android.content.Context;
import android.graphics.Bitmap;
import android.util.AttributeSet;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import com.yandex.mapkit.MapKitFactory;
import com.yandex.mapkit.ScreenPoint;
import com.yandex.mapkit.ScreenRect;
import com.yandex.mapkit.geometry.Point;
import com.yandex.mapkit.map.GestureFocusPointMode;
import com.yandex.mapkit.map.Map;
import com.yandex.mapkit.map.MapWindow;
import com.yandex.mapkit.map.PointOfView;
import com.yandex.mapkit.map.SizeChangedListener;
import com.yandex.mapkit.map.VisibleRegion;
import com.yandex.mapkit.map.internal.MapWindowBinding;
import com.yandex.runtime.view.GraphicsAPIType;
import com.yandex.runtime.view.PlatformGLTextureView;
import com.yandex.runtime.view.PlatformView;
import com.yandex.runtime.view.PlatformViewFactory;
import com.yandex.runtime.view.PlatformVulkanSurfaceView;

public class MapView
extends RelativeLayout {
    private PlatformView platformView;
    private MapWindowBinding mapWindow;

    public MapView(Context context) {
        this(context, null, 0);
    }

    public MapView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public MapView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        if (!this.isInEditMode()) {
            MapKitFactory.initialize(context);
            this.platformView = PlatformViewFactory.getPlatformView(context, PlatformViewFactory.convertAttributeSet(context, attrs));
            this.init(context);
        }
    }

    private void init(Context context) {
        this.mapWindow = (MapWindowBinding)MapKitFactory.getInstance().createMapWindow(this.platformView);
        this.addView(this.platformView.getView(), (ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-1, -1));
    }

    public int width() {
        return this.mapWindow.width();
    }

    public int height() {
        return this.mapWindow.height();
    }

    public float getScaleFactor() {
        return this.mapWindow.getScaleFactor();
    }

    public void setScaleFactor(float scaleFactor) {
        this.mapWindow.setScaleFactor(scaleFactor);
    }

    public void startPerformanceMetricsCapture() {
        this.mapWindow.startPerformanceMetricsCapture();
    }

    public String stopPerformanceMetricsCapture() {
        return this.mapWindow.stopPerformanceMetricsCapture();
    }

    public void setMaxFps(float fps) {
        this.mapWindow.setMaxFps(fps);
    }

    public Map getMap() {
        return this.mapWindow.getMap();
    }

    public ScreenPoint worldToScreen(Point worldPoint) {
        return this.mapWindow.worldToScreen(worldPoint);
    }

    public Point screenToWorld(ScreenPoint screenPoint) {
        return this.mapWindow.screenToWorld(screenPoint);
    }

    public ScreenRect getFocusRect() {
        return this.mapWindow.getFocusRect();
    }

    public void setFocusRect(ScreenRect rect) {
        this.mapWindow.setFocusRect(rect);
    }

    public ScreenPoint getFocusPoint() {
        return this.mapWindow.getFocusPoint();
    }

    public void setFocusPoint(ScreenPoint point) {
        this.mapWindow.setFocusPoint(point);
    }

    public ScreenPoint getGestureFocusPoint() {
        return this.mapWindow.getGestureFocusPoint();
    }

    public void setGestureFocusPoint(ScreenPoint gestureFocusPoint) {
        this.mapWindow.setGestureFocusPoint(gestureFocusPoint);
    }

    public GestureFocusPointMode getGestureFocusPointMode() {
        return this.mapWindow.getGestureFocusPointMode();
    }

    public void setGestureFocusPointMode(GestureFocusPointMode gestureFocusPoint) {
        this.mapWindow.setGestureFocusPointMode(gestureFocusPoint);
    }

    public PointOfView getPointOfView() {
        return this.mapWindow.getPointOfView();
    }

    public void setPointOfView(PointOfView pointOfView) {
        this.mapWindow.setPointOfView(pointOfView);
    }

    public double getFieldOfViewY() {
        return this.mapWindow.getFieldOfViewY();
    }

    public void setFieldOfViewY(double fovY) {
        this.mapWindow.setFieldOfViewY(fovY);
    }

    public VisibleRegion getFocusRegion() {
        return this.mapWindow.getFocusRegion();
    }

    public void addSizeChangedListener(SizeChangedListener listener) {
        this.mapWindow.addSizeChangedListener(listener);
    }

    public void removeSizeChangedListener(SizeChangedListener listener) {
        this.mapWindow.removeSizeChangedListener(listener);
    }

    public void setNoninteractive(boolean is) {
        this.platformView.setNoninteractive(is);
    }

    public boolean isValid() {
        return this.mapWindow.isValid();
    }

    public void onStop() {
        this.platformView.pause();
        this.platformView.stop();
    }

    public void onStart() {
        this.platformView.start();
        this.platformView.resume();
    }

    public Bitmap getScreenshot() {
        if (this.platformView instanceof PlatformGLTextureView) {
            PlatformGLTextureView textureView = (PlatformGLTextureView)this.platformView;
            return textureView.getBitmap();
        }
        return null;
    }

    public void onMemoryWarning() {
        this.platformView.onMemoryWarning();
    }

    public MapWindow getMapWindow() {
        return this.mapWindow;
    }

    public GraphicsAPIType getGraphicsAPI() {
        if (this.platformView instanceof PlatformVulkanSurfaceView) {
            return GraphicsAPIType.VULKAN;
        }
        return GraphicsAPIType.OPEN_GL;
    }
}

