/*
 * Decompiled with CFR 0.152.
 */
package com.yandex.mapkit.offline_cache.internal;

import android.os.Handler;
import android.os.Looper;
import com.evernote.android.job.patched.internal.Job;
import java.util.logging.Logger;

public class BackgroundDownloadJob
extends Job {
    protected static final String TAG = "mapkit_background_download";
    private static Logger LOGGER = Logger.getLogger(BackgroundDownloadJob.class.getCanonicalName());
    private Runnable initializer;

    protected BackgroundDownloadJob(Runnable initializer) {
        this.initializer = initializer;
    }

    @Override
    protected synchronized Job.Result onRunJob(Job.Params params) {
        LOGGER.info("Start background download job");
        if (this.initializer != null) {
            Handler handler = new Handler(Looper.getMainLooper());
            handler.post(this.initializer);
            this.initializer = null;
        }
        try {
            this.wait();
        }
        catch (InterruptedException e) {
            LOGGER.info("Background download job interrupted");
            return Job.Result.RESCHEDULE;
        }
        LOGGER.info("Stop background download job");
        return Job.Result.SUCCESS;
    }

    @Override
    protected synchronized void onCancel() {
        this.notifyAll();
    }
}

