/*
 * Decompiled with CFR 0.152.
 */
package com.yandex.mapkit.offline_cache.internal;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.evernote.android.job.patched.internal.Job;
import com.evernote.android.job.patched.internal.JobConfig;
import com.evernote.android.job.patched.internal.JobCreator;
import com.evernote.android.job.patched.internal.JobManager;
import com.evernote.android.job.patched.internal.JobRequest;
import com.yandex.mapkit.offline_cache.internal.BackgroundDownloadJob;
import com.yandex.runtime.Runtime;

public class BackgroundDownloadManager {
    private int activeDownloads = 0;
    private boolean allowCellular = false;
    private static BackgroundDownloadManager instance = null;

    public static void initialize(@Nullable Runnable mapkitInitializer, @NonNull Context context) {
        if (instance != null) {
            if (mapkitInitializer != null) {
                throw new RuntimeException("BackgroundDownloadManager reinitialization");
            }
            return;
        }
        instance = new BackgroundDownloadManager(mapkitInitializer, context);
    }

    public static BackgroundDownloadManager getInstance() {
        BackgroundDownloadManager.initialize(null, Runtime.getApplicationContext());
        return instance;
    }

    protected void incrementActiveDownloads() {
        ++this.activeDownloads;
        if (this.activeDownloads == 1) {
            this.enableBackgroundDownloading();
        }
    }

    protected void decrementActiveDownloads() {
        assert (this.activeDownloads > 0);
        --this.activeDownloads;
        if (this.activeDownloads == 0) {
            this.disableBackgroundDownloading();
        }
    }

    protected void updateBackgroundDownloading(boolean allowCellular) {
        this.allowCellular = allowCellular;
        if (!JobManager.instance().getAllJobRequestsForTag("mapkit_background_download").isEmpty() || !JobManager.instance().getAllJobsForTag("mapkit_background_download").isEmpty()) {
            this.enableBackgroundDownloading();
        }
    }

    private BackgroundDownloadManager(final @Nullable Runnable mapkitInitializer, Context context) {
        JobConfig.setForceAllowApi14(true);
        JobManager.create(context).addJobCreator(new JobCreator(){

            @Override
            public Job create(String tag) {
                return tag.equals("mapkit_background_download") ? new BackgroundDownloadJob(mapkitInitializer) : null;
            }
        });
    }

    private void enableBackgroundDownloading() {
        new JobRequest.Builder("mapkit_background_download").setExecutionWindow(1L, 0x2AAAAAAAAAAAAAAAL).setUpdateCurrent(true).setRequiredNetworkType(this.allowCellular ? JobRequest.NetworkType.CONNECTED : JobRequest.NetworkType.UNMETERED).setRequirementsEnforced(true).build().schedule();
    }

    private void disableBackgroundDownloading() {
        JobManager.instance().cancelAllForTag("mapkit_background_download");
    }
}

