/*
 * Decompiled with CFR 0.152.
 */
package com.yandex.mapkit.render.internal;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.util.SparseArray;
import com.yandex.mapkit.render.internal.Size;
import com.yandex.runtime.device.internal.DeviceInfo;
import com.yandex.runtime.image.ImageProvider;

public class TextualImageProvider
extends ImageProvider {
    private static final float DELTA = 1.5f;
    private static final float FONT_SCALE = 1.0f;
    private static final SparseArray<Paint> map = new SparseArray();
    private final String id;
    private final Bitmap bitmap;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Paint getPaint(int fontSize) {
        SparseArray<Paint> sparseArray = map;
        synchronized (sparseArray) {
            Paint paint = (Paint)map.get(fontSize);
            if (paint == null) {
                paint = new Paint();
                paint.setTextSize((float)fontSize * 1.0f * DeviceInfo.pixelsPerPoint());
                paint.setTextAlign(Paint.Align.LEFT);
                paint.setStyle(Paint.Style.FILL);
                paint.setAntiAlias(true);
                map.put(fontSize, (Object)paint);
            }
            return paint;
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public Bitmap getImage() {
        return this.bitmap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TextualImageProvider(String textToRender, int fontSize, boolean isOutlined, int fontColor, int outlineColor) {
        this.id = "text:" + textToRender + " fontSize:" + fontSize + " isOutlined:" + isOutlined;
        Paint paint = TextualImageProvider.getPaint(fontSize);
        float widthF = paint.measureText(textToRender);
        Paint.FontMetrics metrics = paint.getFontMetrics();
        float heightF = Math.abs(metrics.bottom) + Math.abs(metrics.top);
        int width = (int)(widthF + 0.5f);
        int height = (int)(heightF + 0.5f);
        this.bitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(this.bitmap);
        float ascent = Math.abs(metrics.ascent);
        SparseArray<Paint> sparseArray = map;
        synchronized (sparseArray) {
            if (isOutlined) {
                paint.setColor(outlineColor);
                canvas.drawText(textToRender, -1.5f, ascent - 1.5f, paint);
                canvas.drawText(textToRender, 1.5f, ascent - 1.5f, paint);
                canvas.drawText(textToRender, 1.5f, ascent + 1.5f, paint);
                canvas.drawText(textToRender, -1.5f, ascent + 1.5f, paint);
            }
            paint.setColor(fontColor);
            canvas.drawText(textToRender, 0.0f, ascent, paint);
        }
    }

    public static Size measureText(String text, int fontSize) {
        Paint paint = TextualImageProvider.getPaint(fontSize);
        float widthF = paint.measureText(text);
        Paint.FontMetrics metrics = paint.getFontMetrics();
        float heightF = Math.abs(metrics.bottom) + Math.abs(metrics.top);
        return new Size((int)(widthF + 0.5f), (int)(heightF + 0.5f));
    }

    public static int baseline(int fontSize) {
        Paint.FontMetrics metrics = TextualImageProvider.getPaint(fontSize).getFontMetrics();
        return Math.round(Math.abs(metrics.ascent));
    }
}

