/*
 * Decompiled with CFR 0.152.
 */
package com.yandex.runtime;

import android.content.res.AssetManager;
import android.content.res.Resources;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

public final class ByteBufferUtils {
    private ByteBufferUtils() {
    }

    public static ByteBuffer fromByteArray(byte[] data) {
        ByteBuffer buffer = ByteBuffer.allocateDirect(data.length);
        buffer.put(data);
        return buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ByteBuffer fromInputStream(InputStream inputStream) throws IOException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            int readBytesNum;
            byte[] buffer = new byte[16384];
            while ((readBytesNum = inputStream.read(buffer, 0, buffer.length)) != -1) {
                outputStream.write(buffer, 0, readBytesNum);
            }
            outputStream.flush();
            ByteBuffer byteBuffer = ByteBufferUtils.fromByteArray(outputStream.toByteArray());
            return byteBuffer;
        }
        finally {
            inputStream.close();
        }
    }

    public static ByteBuffer fromResource(Resources resources, int resourceId) throws IOException {
        return ByteBufferUtils.fromInputStream(resources.openRawResource(resourceId));
    }

    public static ByteBuffer fromAsset(AssetManager assetManager, String assetName) throws IOException {
        return ByteBufferUtils.fromInputStream(assetManager.open(assetName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ByteBuffer fromFile(String fileName) throws IOException {
        File file = new File(fileName);
        FileInputStream fileStream = new FileInputStream(file);
        DataInputStream dataStream = new DataInputStream(fileStream);
        try {
            byte[] buffer = new byte[(int)file.length()];
            dataStream.readFully(buffer);
            ByteBuffer byteBuffer = ByteBufferUtils.fromByteArray(buffer);
            return byteBuffer;
        }
        finally {
            fileStream.close();
        }
    }
}

