/*
 * Decompiled with CFR 0.152.
 */
package com.yandex.runtime;

import android.os.Handler;
import android.os.Looper;

public final class NativeObject {
    private long nativeObject;
    private boolean canBeDeletedInBackground;

    public NativeObject(long nativeObject, boolean canBeDeletedInBackground) {
        this.nativeObject = nativeObject;
        this.canBeDeletedInBackground = canBeDeletedInBackground;
    }

    public boolean isEmpty() {
        return this.nativeObject == 0L;
    }

    public long release() {
        if (Looper.myLooper() != Looper.getMainLooper()) {
            throw new IllegalStateException("Cannot release native object outside the UI thread");
        }
        long result = this.nativeObject;
        this.nativeObject = 0L;
        return result;
    }

    public void reset() {
        if (Looper.myLooper() != Looper.getMainLooper()) {
            throw new IllegalStateException("Cannot reset native object outside the UI thread");
        }
        NativeObject.deleteNative(this.nativeObject);
        this.nativeObject = 0L;
    }

    public void finalize() throws Throwable {
        if (this.isEmpty()) {
            return;
        }
        if (this.canBeDeletedInBackground) {
            NativeObject.deleteNative(this.nativeObject);
        } else {
            new Handler(Looper.getMainLooper()).post((Runnable)new Cleaner(this.nativeObject));
        }
        this.nativeObject = 0L;
    }

    private static native void deleteNative(long var0);

    private static final class Cleaner
    implements Runnable {
        private final long nativeObject;

        public Cleaner(long nativeObject) {
            this.nativeObject = nativeObject;
        }

        @Override
        public void run() {
            NativeObject.deleteNative(this.nativeObject);
        }
    }
}

