/*
 * Decompiled with CFR 0.152.
 */
package com.yandex.runtime;

import android.app.ActivityManager;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.os.Looper;
import android.os.Process;
import com.yandex.runtime.RuntimeBase;
import com.yandex.runtime.internal.ReLinker;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;

public class Runtime
extends RuntimeBase {
    private static final String TAG = Runtime.class.getCanonicalName();
    private static Context applicationContext;
    private static boolean allLibrariesLoaded;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isMainProcess(Context context) {
        String packageName = context.getPackageName();
        ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
        List runningApps = activityManager.getRunningAppProcesses();
        if (runningApps != null) {
            for (ActivityManager.RunningAppProcessInfo process : runningApps) {
                if (Process.myPid() != process.pid) continue;
                return packageName.equals(process.processName);
            }
        }
        BufferedReader cmdlineReader = null;
        try {
            try {
                int c;
                cmdlineReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream("/proc/" + Process.myPid() + "/cmdline"), "iso-8859-1"));
                StringBuilder processName = new StringBuilder();
                while ((c = cmdlineReader.read()) > 0) {
                    processName.append((char)c);
                }
                if (!packageName.equals(processName.toString())) return false;
                boolean bl = true;
                return bl;
            }
            finally {
                if (cmdlineReader != null) {
                    cmdlineReader.close();
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    public static void init(Context context, String libraryName) {
        if (context == null) {
            throw new RuntimeException("null context passed to init");
        }
        if (!Runtime.isMainProcess(context)) {
            throw new RuntimeException("Runtime could be initialized from the application's main process");
        }
        if (Looper.myLooper() != Looper.getMainLooper()) {
            throw new RuntimeException("Runtime could only be initialized from ui thread");
        }
        if (applicationContext == null) {
            ApplicationInfo info;
            applicationContext = context.getApplicationContext();
            String packageName = applicationContext.getPackageName();
            try {
                info = applicationContext.getPackageManager().getApplicationInfo(packageName, 128);
            }
            catch (PackageManager.NameNotFoundException e) {
                throw new RuntimeException("Could not find package info");
            }
            String stlLinkage = info.metaData.getString("yandex.maps.runtime.stl.linkage");
            if (stlLinkage != null && stlLinkage.equals("dynamic")) {
                Runtime.loadLibrary(context, "c++_shared");
            }
            Runtime.loadLibrary(context, libraryName);
        }
        Runtime.initUiThread();
    }

    public static void init(Context context) {
        Runtime.init(context, "maps-mobile");
    }

    public static Context getApplicationContext() {
        if (applicationContext == null) {
            throw new RuntimeException("init has not been called");
        }
        return applicationContext;
    }

    public static void loadLibrary(Context context, String library) {
        if (allLibrariesLoaded) {
            return;
        }
        try {
            ReLinker.loadLibrary(context, library);
        }
        catch (RuntimeException ex) {
            throw new UnsatisfiedLinkError("Couldn't load " + library + ", reason: " + ex.getMessage());
        }
    }

    private static native void initUiThread();

    static {
        allLibrariesLoaded = false;
    }
}

