/*
 * Decompiled with CFR 0.152.
 */
package com.yandex.runtime.bindings;

import com.yandex.runtime.bindings.ArchivingHandler;
import com.yandex.runtime.bindings.internal.ArchiveReader;
import com.yandex.runtime.bindings.internal.ArchiveWriter;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;

public class Marshalling {
    public static <T> ByteBuffer serialize(T object, ArchivingHandler<T> handler) {
        ArchiveWriter writer = new ArchiveWriter();
        writer.add(object, handler);
        return writer.data();
    }

    public static <T> ByteBuffer serializeArray(List<T> array, ArchivingHandler<T> handler) {
        ArchiveWriter writer = new ArchiveWriter();
        writer.add(array, false, handler);
        return writer.data();
    }

    public static <K, V> ByteBuffer serializeMap(Map<K, V> map, ArchivingHandler<K> keyHandler, ArchivingHandler<V> valueHandler) {
        ArchiveWriter writer = new ArchiveWriter();
        writer.add(map, false, keyHandler, valueHandler);
        return writer.data();
    }

    public static <T> T deserialize(ByteBuffer buffer, ArchivingHandler<T> handler) {
        ArchiveReader reader = new ArchiveReader(buffer);
        return reader.add(null, handler);
    }

    public static <T> List<T> deserializeArray(ByteBuffer buffer, ArchivingHandler<T> handler) {
        ArchiveReader reader = new ArchiveReader(buffer);
        return reader.add((List)null, false, handler);
    }

    public static <K, V> Map<K, V> deserializeMap(ByteBuffer buffer, ArchivingHandler<K> keyHandler, ArchivingHandler<V> valueHandler) {
        ArchiveReader reader = new ArchiveReader(buffer);
        return reader.add(null, false, keyHandler, valueHandler);
    }
}

