/*
 * Decompiled with CFR 0.152.
 */
package com.yandex.runtime.bindings.internal;

import android.graphics.PointF;
import com.yandex.runtime.bindings.Archive;
import com.yandex.runtime.bindings.ArchivingHandler;
import com.yandex.runtime.bindings.Serializable;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class ArchiveReader
implements Archive {
    private final ByteBuffer data;

    public ArchiveReader(ByteBuffer data) {
        this.data = data;
        this.data.position(0);
        this.data.order(ByteOrder.nativeOrder());
    }

    @Override
    public boolean isReader() {
        return true;
    }

    @Override
    public boolean add(boolean value) {
        byte byteValue = this.add((byte)0);
        if (byteValue == 1) {
            return true;
        }
        if (byteValue == 0) {
            return false;
        }
        throw new RuntimeException(String.format("0x%02x is not valid boolean value", byteValue));
    }

    @Override
    public byte add(byte value) {
        return this.data.get();
    }

    @Override
    public int add(int value) {
        return this.data.getInt();
    }

    @Override
    public long add(long value) {
        return this.data.getLong();
    }

    @Override
    public float add(float value) {
        return this.data.getFloat();
    }

    @Override
    public double add(double value) {
        return this.data.getDouble();
    }

    private boolean readOptionalFlag() {
        return this.add(false);
    }

    @Override
    public Boolean add(Boolean value, boolean optional) {
        if (optional && !this.readOptionalFlag()) {
            return null;
        }
        return this.add(false);
    }

    @Override
    public Byte add(Byte value, boolean optional) {
        if (optional && !this.readOptionalFlag()) {
            return null;
        }
        return this.add((byte)0);
    }

    @Override
    public Integer add(Integer value, boolean optional) {
        if (optional && !this.readOptionalFlag()) {
            return null;
        }
        return this.add(0);
    }

    @Override
    public Long add(Long value, boolean optional) {
        if (optional && !this.readOptionalFlag()) {
            return null;
        }
        return this.add(0L);
    }

    @Override
    public Float add(Float value, boolean optional) {
        if (optional && !this.readOptionalFlag()) {
            return null;
        }
        return Float.valueOf(this.add(0.0f));
    }

    @Override
    public Double add(Double value, boolean optional) {
        if (optional && !this.readOptionalFlag()) {
            return null;
        }
        return this.add(0.0);
    }

    @Override
    public ByteBuffer add(ByteBuffer buffer) {
        return this.data;
    }

    @Override
    public byte[] add(byte[] value, boolean optional) {
        if (optional && !this.readOptionalFlag()) {
            return null;
        }
        int length = this.add(0);
        byte[] bytes = new byte[length];
        this.data.get(bytes);
        return bytes;
    }

    @Override
    public String add(String string, boolean optional) {
        if (optional && !this.readOptionalFlag()) {
            return null;
        }
        int length = this.add(0);
        try {
            byte[] bytes = new byte[length];
            this.data.get(bytes);
            return new String(bytes, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <T extends Enum<T>> T add(T value, boolean optional, Class<T> cls) {
        if (optional && !this.readOptionalFlag()) {
            return null;
        }
        return (T)((Enum[])cls.getEnumConstants())[this.add(0)];
    }

    @Override
    public <T> List<T> add(List<T> list, boolean optional, ArchivingHandler<T> handler) {
        if (optional && !this.readOptionalFlag()) {
            return null;
        }
        list = new ArrayList<T>();
        int length = this.add(0);
        for (int i = 0; i < length; ++i) {
            list.add(handler.add(null, this));
        }
        return list;
    }

    @Override
    public <Key, Value> Map<Key, Value> add(Map<Key, Value> map, boolean optional, ArchivingHandler<Key> keyHandler, ArchivingHandler<Value> valueHandler) {
        if (optional && !this.readOptionalFlag()) {
            return null;
        }
        map = new HashMap<Key, Value>();
        int length = this.add(0);
        for (int i = 0; i < length; ++i) {
            Object key = keyHandler.add(null, this);
            Object value = valueHandler.add(null, this);
            map.put(key, value);
        }
        return map;
    }

    private static <T> T create(Class<T> cls) {
        try {
            Constructor<T> constructor = cls.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            return constructor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Cannot create an instance of class %s. %s", cls.getName(), e.getMessage()));
        }
    }

    @Override
    public <T extends Serializable> T add(T object, boolean optional, Class<T> cls) {
        if (optional && !this.readOptionalFlag()) {
            return null;
        }
        object = (Serializable)ArchiveReader.create(cls);
        object.serialize(this);
        return (T)object;
    }

    @Override
    public <T> T add(T object, ArchivingHandler<T> handler) {
        return handler.add(object, this);
    }

    @Override
    public PointF add(PointF value, boolean optional) {
        if (optional && !this.readOptionalFlag()) {
            return null;
        }
        return new PointF(this.add(0.0f), this.add(0.0f));
    }
}

