/*
 * Decompiled with CFR 0.152.
 */
package com.yandex.runtime.bindings.internal;

import android.graphics.PointF;
import com.yandex.runtime.bindings.Archive;
import com.yandex.runtime.bindings.ArchivingHandler;
import com.yandex.runtime.bindings.Serializable;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.List;
import java.util.Map;

public final class ArchiveWriter
implements Archive {
    private ByteBuffer data = ArchiveWriter.allocate(16384);
    private static final int DEFAULT_SIZE = 16384;

    public ByteBuffer data() {
        return this.data;
    }

    private static ByteBuffer allocate(int size) {
        return ByteBuffer.allocateDirect(size).order(ByteOrder.nativeOrder());
    }

    private void ensureSize(int add) {
        int size;
        int position = this.data.position();
        if (position + add > (size = this.data.capacity())) {
            size = Math.max((int)((double)size * 1.6), position + add);
            ByteBuffer newBuffer = ArchiveWriter.allocate(size);
            this.data.position(0);
            newBuffer.put(this.data);
            newBuffer.position(position);
            this.data = newBuffer;
        }
    }

    @Override
    public boolean isReader() {
        return false;
    }

    @Override
    public boolean add(boolean value) {
        byte byteValue = value ? (byte)1 : 0;
        this.add(byteValue);
        return value;
    }

    @Override
    public byte add(byte value) {
        this.ensureSize(1);
        this.data.put(value);
        return value;
    }

    @Override
    public int add(int value) {
        this.ensureSize(4);
        this.data.putInt(value);
        return value;
    }

    @Override
    public long add(long value) {
        this.ensureSize(8);
        this.data.putLong(value);
        return value;
    }

    @Override
    public float add(float value) {
        this.ensureSize(4);
        this.data.putFloat(value);
        return value;
    }

    @Override
    public double add(double value) {
        this.ensureSize(8);
        this.data.putDouble(value);
        return value;
    }

    private <T> boolean writeOptionalFlag(boolean optional, T object) {
        if (!optional) {
            assert (object != null);
            return true;
        }
        boolean value = object != null;
        return this.add(value);
    }

    @Override
    public Boolean add(Boolean value, boolean optional) {
        if (!this.writeOptionalFlag(optional, value)) {
            return null;
        }
        return this.add(value);
    }

    @Override
    public Byte add(Byte value, boolean optional) {
        if (!this.writeOptionalFlag(optional, value)) {
            return null;
        }
        return this.add(value);
    }

    @Override
    public Integer add(Integer value, boolean optional) {
        if (!this.writeOptionalFlag(optional, value)) {
            return null;
        }
        return this.add(value);
    }

    @Override
    public Long add(Long value, boolean optional) {
        if (!this.writeOptionalFlag(optional, value)) {
            return null;
        }
        return this.add(value);
    }

    @Override
    public Float add(Float value, boolean optional) {
        if (!this.writeOptionalFlag(optional, value)) {
            return null;
        }
        return Float.valueOf(this.add(value.floatValue()));
    }

    @Override
    public Double add(Double value, boolean optional) {
        if (!this.writeOptionalFlag(optional, value)) {
            return null;
        }
        return this.add(value);
    }

    @Override
    public ByteBuffer add(ByteBuffer buffer) {
        this.ensureSize(buffer.capacity());
        this.data.put(buffer);
        return this.data;
    }

    @Override
    public byte[] add(byte[] bytes, boolean optional) {
        if (!this.writeOptionalFlag(optional, bytes)) {
            return null;
        }
        this.add(bytes.length);
        this.ensureSize(bytes.length);
        this.data.put(bytes);
        return bytes;
    }

    @Override
    public String add(String string, boolean optional) {
        byte[] bytes;
        if (!this.writeOptionalFlag(optional, string)) {
            return null;
        }
        try {
            bytes = string.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.add(bytes.length);
        this.ensureSize(bytes.length);
        this.data.put(bytes);
        return string;
    }

    @Override
    public <T extends Enum<T>> T add(T value, boolean optional, Class<T> cls) {
        if (!this.writeOptionalFlag(optional, value)) {
            return null;
        }
        this.add(value.ordinal());
        return value;
    }

    @Override
    public <T> List<T> add(List<T> list, boolean optional, ArchivingHandler<T> handler) {
        if (!this.writeOptionalFlag(optional, list)) {
            return null;
        }
        this.add(list.size());
        for (T value : list) {
            handler.add(value, this);
        }
        return list;
    }

    @Override
    public <Key, Value> Map<Key, Value> add(Map<Key, Value> map, boolean optional, ArchivingHandler<Key> keyHandler, ArchivingHandler<Value> valueHandler) {
        if (!this.writeOptionalFlag(optional, map)) {
            return null;
        }
        this.add(map.size());
        for (Map.Entry<Key, Value> entry : map.entrySet()) {
            keyHandler.add(entry.getKey(), this);
            valueHandler.add(entry.getValue(), this);
        }
        return map;
    }

    @Override
    public <T extends Serializable> T add(T object, boolean optional, Class<T> cls) {
        if (!this.writeOptionalFlag(optional, object)) {
            return null;
        }
        object.serialize(this);
        return object;
    }

    @Override
    public <T> T add(T object, ArchivingHandler<T> handler) {
        return handler.add(object, this);
    }

    @Override
    public PointF add(PointF value, boolean optional) {
        if (!this.writeOptionalFlag(optional, value)) {
            return null;
        }
        this.add(value.x);
        this.add(value.y);
        return value;
    }
}

