/*
 * Decompiled with CFR 0.152.
 */
package com.yandex.runtime.bindings.internal;

import com.yandex.runtime.bindings.Serializable;
import java.util.HashMap;
import java.util.Map;

public class GuidRegister {
    private static final Map<String, Class<? extends Serializable>> guidsToClassesMap = new HashMap<String, Class<? extends Serializable>>();
    private static final Map<Class<? extends Serializable>, String> classesToGuidsMap = new HashMap<Class<? extends Serializable>, String>();

    public static void registerGuid(Class<? extends Serializable> cls, String guid) {
        guidsToClassesMap.put(guid, cls);
        classesToGuidsMap.put(cls, guid);
    }

    public static String getGuid(Class<? extends Serializable> cls) {
        String guid = classesToGuidsMap.get(cls);
        if (guid == null) {
            throw new RuntimeException("Unknown guid for class " + cls.getName());
        }
        return guid;
    }

    public static Class<? extends Serializable> getClass(String guid) {
        Class<? extends Serializable> cls = guidsToClassesMap.get(guid);
        if (cls == null) {
            throw new RuntimeException("Unregistered guid " + guid);
        }
        return cls;
    }
}

