/*
 * Decompiled with CFR 0.152.
 */
package com.yandex.runtime.connectivity.internal;

import android.app.job.JobInfo;
import android.app.job.JobScheduler;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import com.yandex.runtime.NativeObject;
import com.yandex.runtime.Runtime;
import com.yandex.runtime.connectivity.ConnectivityStatus;
import com.yandex.runtime.connectivity.internal.ConnectivityService;

public class ConnectivitySubscription
extends BroadcastReceiver {
    private NativeObject nativePromise;
    private ConnectivityManager connectivityManager = (ConnectivityManager)Runtime.getApplicationContext().getSystemService("connectivity");
    private Object jobScheduler = Runtime.getApplicationContext().getSystemService("jobscheduler");
    private boolean isRegistered = false;
    private static final String ACTION_LIGHT_DEVICE_IDLE_MODE_CHANGED = "android.os.action.LIGHT_DEVICE_IDLE_MODE_CHANGED";
    public static final String ACTION_CONNECTIVITY_CHANGED = "com.yandex.runtime.internal.CONNECTIVITY_CHANGED";
    private static final String TAG = ConnectivitySubscription.class.getCanonicalName();

    public void subscribe(NativeObject promise) {
        this.nativePromise = promise;
        Handler handler = new Handler(Looper.getMainLooper());
        handler.post(new Runnable(){

            @Override
            public void run() {
                IntentFilter filter = new IntentFilter();
                filter.addAction("android.net.conn.CONNECTIVITY_CHANGE");
                filter.addAction(ConnectivitySubscription.ACTION_CONNECTIVITY_CHANGED);
                filter.addAction("android.os.action.DEVICE_IDLE_MODE_CHANGED");
                filter.addAction(ConnectivitySubscription.ACTION_LIGHT_DEVICE_IDLE_MODE_CHANGED);
                try {
                    Runtime.getApplicationContext().registerReceiver((BroadcastReceiver)ConnectivitySubscription.this, filter);
                    ConnectivitySubscription.this.isRegistered = true;
                    ConnectivitySubscription.this.update(ConnectivitySubscription.this.status());
                }
                catch (SecurityException exc) {
                    Log.e((String)TAG, (String)"Cannot register receiver", (Throwable)exc);
                }
            }
        });
    }

    public void unsubscribe() {
        Handler handler = new Handler(Looper.getMainLooper());
        handler.post(new Runnable(){

            @Override
            public void run() {
                if (ConnectivitySubscription.this.isRegistered) {
                    Runtime.getApplicationContext().unregisterReceiver((BroadcastReceiver)ConnectivitySubscription.this);
                }
                ConnectivitySubscription.this.isRegistered = false;
            }
        });
    }

    public ConnectivityStatus status() {
        NetworkInfo networkInfo = this.connectivityManager.getActiveNetworkInfo();
        if (networkInfo == null || !networkInfo.isConnected()) {
            return ConnectivityStatus.NONE;
        }
        switch (networkInfo.getType()) {
            case 0: 
            case 4: 
            case 7: {
                return ConnectivityStatus.CELLULAR;
            }
        }
        return ConnectivityStatus.BROADBAND;
    }

    public void onReceive(Context context, Intent intent) {
        int jobId = 4105;
        String action = intent.getAction();
        ConnectivityStatus currentStatus = this.status();
        this.update(currentStatus);
        if ((action == ACTION_LIGHT_DEVICE_IDLE_MODE_CHANGED || action == "android.os.action.DEVICE_IDLE_MODE_CHANGED") && currentStatus == ConnectivityStatus.NONE) {
            JobInfo job = new JobInfo.Builder(jobId, new ComponentName(Runtime.getApplicationContext(), ConnectivityService.class)).setRequiredNetworkType(1).build();
            ((JobScheduler)this.jobScheduler).schedule(job);
        }
    }

    private void update(ConnectivityStatus status) {
        try {
            ConnectivitySubscription.submit(this.nativePromise, status);
        }
        catch (UnsatisfiedLinkError ex) {
            Log.e((String)TAG, (String)("Native libraries not loaded: " + ex.getMessage()));
        }
    }

    static native void submit(NativeObject var0, ConnectivityStatus var1);
}

