/*
 * Decompiled with CFR 0.152.
 */
package com.yandex.runtime.image;

import android.content.Context;
import android.content.res.AssetManager;
import android.content.res.Resources;
import android.util.Log;
import com.yandex.runtime.ByteBufferUtils;
import com.yandex.runtime.image.AnimatedImage;
import java.io.IOException;
import java.util.UUID;

public abstract class AnimatedImageProvider {
    public abstract String getId();

    public abstract Object getImage();

    public static AnimatedImageProvider fromByteArray(final byte[] image) {
        final String id = "animation/bytes:" + UUID.randomUUID().toString();
        return new AnimatedImageProvider(){

            @Override
            public String getId() {
                return id;
            }

            @Override
            public Object getImage() {
                return ByteBufferUtils.fromByteArray(image);
            }
        };
    }

    public static AnimatedImageProvider fromResource(Context context, final int resourceId) {
        final Resources resources = context.getResources();
        return new AnimatedImageProviderImpl("animation/resource:" + String.valueOf(resourceId)){

            @Override
            protected Object loadImage() {
                try {
                    return ByteBufferUtils.fromResource(resources, resourceId);
                }
                catch (IOException ex) {
                    Log.e((String)"yandex.maps", (String)("Can't load animated image from resource: " + String.valueOf(resourceId)), (Throwable)ex);
                    return null;
                }
            }
        };
    }

    public static AnimatedImageProvider fromAsset(Context context, final String assetName) {
        final AssetManager assetManager = context.getAssets();
        return new AnimatedImageProviderImpl("animation/asset:" + assetName){

            @Override
            protected Object loadImage() {
                try {
                    return ByteBufferUtils.fromAsset(assetManager, assetName);
                }
                catch (IOException ex) {
                    Log.e((String)"yandex.maps", (String)("Can't load animated image from asset: " + assetName), (Throwable)ex);
                    return null;
                }
            }
        };
    }

    public static AnimatedImageProvider fromFile(final String fileName) {
        return new AnimatedImageProviderImpl("animation/file:" + fileName){

            @Override
            protected Object loadImage() {
                try {
                    return ByteBufferUtils.fromFile(fileName);
                }
                catch (IOException ex) {
                    Log.e((String)"yandex.maps", (String)("Can't load animated image from file: " + fileName), (Throwable)ex);
                    return null;
                }
            }
        };
    }

    public static AnimatedImageProvider fromAnimatedImage(final AnimatedImage image) {
        final String id = "animation/image:" + UUID.randomUUID().toString();
        return new AnimatedImageProvider(){

            @Override
            public String getId() {
                return id;
            }

            @Override
            public Object getImage() {
                return image;
            }
        };
    }

    private static abstract class AnimatedImageProviderImpl
    extends AnimatedImageProvider {
        private final String id;
        private Object image;

        public AnimatedImageProviderImpl(String id) {
            this.id = id;
        }

        @Override
        public String getId() {
            return this.id;
        }

        @Override
        public Object getImage() {
            if (this.image == null) {
                this.image = this.loadImage();
            }
            return this.image;
        }

        protected abstract Object loadImage();
    }
}

