/*
 * Decompiled with CFR 0.152.
 */
package com.yandex.runtime.image;

import android.content.Context;
import android.content.res.AssetManager;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.util.Log;
import java.io.IOException;
import java.io.InputStream;
import java.util.UUID;

public abstract class ImageProvider {
    private final boolean cacheable;

    public ImageProvider() {
        this(true);
    }

    public ImageProvider(boolean cacheable) {
        this.cacheable = cacheable;
    }

    public boolean isCacheable() {
        return this.cacheable;
    }

    public abstract String getId();

    public abstract Bitmap getImage();

    public static ImageProvider fromBitmap(Bitmap bitmap) {
        return ImageProvider.fromBitmap(bitmap, true, "bitmap:" + UUID.randomUUID().toString());
    }

    public static ImageProvider fromBitmap(final Bitmap bitmap, boolean cacheable, final String id) {
        if (bitmap.getConfig() != Bitmap.Config.ARGB_8888) {
            throw new IllegalArgumentException("Bitmap config value should be ARGB_8888");
        }
        return new ImageProvider(cacheable){

            @Override
            public String getId() {
                return id;
            }

            @Override
            public Bitmap getImage() {
                return bitmap;
            }
        };
    }

    public static ImageProvider fromAsset(Context context, String assetName) {
        return ImageProvider.fromAsset(context, assetName, true);
    }

    public static ImageProvider fromAsset(Context context, final String assetName, boolean cacheable) {
        final AssetManager assetManager = context.getAssets();
        return new ImageProviderImpl("asset:" + assetName, cacheable){

            @Override
            protected Bitmap loadBitmap() {
                Bitmap result = null;
                try (InputStream i = assetManager.open(assetName);){
                    result = BitmapFactory.decodeStream((InputStream)i);
                }
                catch (IOException ex) {
                    Log.e((String)"yandex.maps", (String)("Can't load image from asset: " + assetName), (Throwable)ex);
                }
                return result;
            }
        };
    }

    public static ImageProvider fromResource(Context context, int resourceId) {
        return ImageProvider.fromResource(context, resourceId, true);
    }

    public static ImageProvider fromResource(Context context, final int resourceId, boolean cacheable) {
        final Resources resources = context.getResources();
        return new ImageProviderImpl("resource:" + resourceId, cacheable){

            @Override
            protected Bitmap loadBitmap() {
                return BitmapFactory.decodeResource((Resources)resources, (int)resourceId);
            }
        };
    }

    public static ImageProvider fromFile(String fileName) {
        return ImageProvider.fromFile(fileName, true);
    }

    public static ImageProvider fromFile(final String fileName, boolean cacheable) {
        return new ImageProviderImpl("file:" + fileName, cacheable){

            @Override
            protected Bitmap loadBitmap() {
                return BitmapFactory.decodeFile((String)fileName);
            }
        };
    }

    private static abstract class ImageProviderImpl
    extends ImageProvider {
        private final String id;
        private Bitmap bitmap;

        public ImageProviderImpl(String id, boolean cacheable) {
            super(cacheable);
            this.id = id;
        }

        @Override
        public String getId() {
            return this.id;
        }

        @Override
        public Bitmap getImage() {
            if (this.bitmap == null) {
                this.bitmap = this.loadBitmap();
            }
            return this.bitmap;
        }

        protected abstract Bitmap loadBitmap();
    }
}

