/*
 * Decompiled with CFR 0.152.
 */
package com.yandex.runtime.internal;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.os.Build;
import android.text.TextUtils;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ReLinker {
    private static final String LIB_DIR = "lib";
    private static final int MAX_TRIES = 5;
    private static final int COPY_BUFFER_SIZE = 4096;

    private ReLinker() {
    }

    public static void loadLibrary(Context context, String library) {
        if (context == null) {
            throw new IllegalArgumentException("Given context is null");
        }
        if (TextUtils.isEmpty((CharSequence)library)) {
            throw new IllegalArgumentException("Given library is either null or empty");
        }
        try {
            System.loadLibrary(library);
            return;
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            File workaroundFile = ReLinker.getWorkaroundLibFile(context, library);
            if (!workaroundFile.exists()) {
                ReLinker.unpackLibrary(context, library);
            }
            System.load(workaroundFile.getAbsolutePath());
            return;
        }
    }

    private static File getWorkaroundLibDir(Context context) {
        return context.getDir(LIB_DIR, 0);
    }

    private static File getWorkaroundLibFile(Context context, String library) {
        String libName = System.mapLibraryName(library);
        return new File(ReLinker.getWorkaroundLibDir(context), libName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static void unpackLibrary(Context context, String library) {
        ZipFile zipFile = null;
        try {
            ApplicationInfo appInfo = context.getApplicationInfo();
            int tries = 0;
            while (tries++ < 5) {
                try {
                    zipFile = new ZipFile(new File(appInfo.sourceDir), 1);
                    break;
                }
                catch (IOException iOException) {
                }
            }
            if (zipFile == null) {
                return;
            }
            tries = 0;
            while (tries++ < 5) {
                String jniNameInApk = null;
                ZipEntry libraryEntry = null;
                if (Build.SUPPORTED_ABIS.length > 0) {
                    for (String ABI : Build.SUPPORTED_ABIS) {
                        jniNameInApk = "lib/" + ABI + "/" + System.mapLibraryName(library);
                        libraryEntry = zipFile.getEntry(jniNameInApk);
                        if (libraryEntry == null) {
                            continue;
                        }
                        break;
                    }
                } else {
                    jniNameInApk = "lib/" + Build.CPU_ABI + "/" + System.mapLibraryName(library);
                    libraryEntry = zipFile.getEntry(jniNameInApk);
                }
                if (libraryEntry == null) {
                    if (jniNameInApk != null) {
                        throw new MissingLibraryException(jniNameInApk);
                    }
                    throw new MissingLibraryException(library);
                }
                File outputFile = ReLinker.getWorkaroundLibFile(context, library);
                outputFile.delete();
                try {
                    if (!outputFile.createNewFile()) {
                    }
                }
                catch (IOException ignored) {}
                continue;
                InputStream inputStream = null;
                FileOutputStream fileOut = null;
                try {
                    inputStream = zipFile.getInputStream(libraryEntry);
                    fileOut = new FileOutputStream(outputFile);
                    ReLinker.copy(inputStream, fileOut);
                }
                catch (FileNotFoundException e) {
                    ReLinker.closeSilently(inputStream);
                    ReLinker.closeSilently(fileOut);
                    continue;
                }
                catch (IOException e) {
                    ReLinker.closeSilently(inputStream);
                    ReLinker.closeSilently(fileOut);
                    continue;
                    {
                        catch (Throwable throwable) {
                            ReLinker.closeSilently(inputStream);
                            ReLinker.closeSilently(fileOut);
                            throw throwable;
                        }
                    }
                }
                ReLinker.closeSilently(inputStream);
                ReLinker.closeSilently(fileOut);
                outputFile.setReadable(true, false);
                outputFile.setExecutable(true, false);
                outputFile.setWritable(true);
                break;
            }
        }
        finally {
            try {
                if (zipFile != null) {
                    zipFile.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private static void copy(InputStream in, OutputStream out) throws IOException {
        int read;
        byte[] buf = new byte[4096];
        while ((read = in.read(buf)) != -1) {
            out.write(buf, 0, read);
        }
    }

    private static void closeSilently(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static class MissingLibraryException
    extends RuntimeException {
        public MissingLibraryException(String library) {
            super(library);
        }
    }
}

