/*
 * Decompiled with CFR 0.152.
 */
package com.yandex.runtime.model;

import android.content.Context;
import android.content.res.AssetManager;
import android.content.res.Resources;
import android.util.Log;
import com.yandex.runtime.ByteBufferUtils;
import com.yandex.runtime.image.ImageProvider;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.UUID;

public abstract class ModelProvider {
    public abstract String getId();

    public abstract ByteBuffer getModel();

    public abstract ImageProvider getTexture();

    public static ModelProvider fromByteArray(final byte[] model, final ImageProvider texture) {
        final String id = "model/bytes:" + UUID.randomUUID().toString();
        return new ModelProvider(){

            @Override
            public String getId() {
                return id;
            }

            @Override
            public ByteBuffer getModel() {
                return ByteBufferUtils.fromByteArray(model);
            }

            @Override
            public ImageProvider getTexture() {
                return texture;
            }
        };
    }

    public static ModelProvider fromResource(Context context, final int resourceId, final ImageProvider texture) {
        final Resources resources = context.getResources();
        final String id = "model/resource:" + String.valueOf(resourceId);
        return new ModelProvider(){

            @Override
            public String getId() {
                return id;
            }

            @Override
            public ByteBuffer getModel() {
                try {
                    return ByteBufferUtils.fromResource(resources, resourceId);
                }
                catch (IOException ex) {
                    Log.e((String)"yandex.maps", (String)("Can't load model from resource: " + String.valueOf(resourceId)), (Throwable)ex);
                    return null;
                }
            }

            @Override
            public ImageProvider getTexture() {
                return texture;
            }
        };
    }

    public static ModelProvider fromAsset(Context context, final String assetName, final ImageProvider texture) {
        final AssetManager assetManager = context.getAssets();
        final String id = "model/asset:" + assetName;
        return new ModelProvider(){

            @Override
            public String getId() {
                return id;
            }

            @Override
            public ByteBuffer getModel() {
                try {
                    return ByteBufferUtils.fromAsset(assetManager, assetName);
                }
                catch (IOException ex) {
                    Log.e((String)"yandex.maps", (String)("Can't load model from asset: " + assetName), (Throwable)ex);
                    return null;
                }
            }

            @Override
            public ImageProvider getTexture() {
                return texture;
            }
        };
    }

    public static ModelProvider fromFile(final String fileName, final ImageProvider texture) {
        final String id = "model/file:" + fileName;
        return new ModelProvider(){

            @Override
            public String getId() {
                return id;
            }

            @Override
            public ByteBuffer getModel() {
                try {
                    return ByteBufferUtils.fromFile(fileName);
                }
                catch (IOException ex) {
                    Log.e((String)"yandex.maps", (String)("Can't load model from file: " + fileName), (Throwable)ex);
                    return null;
                }
            }

            @Override
            public ImageProvider getTexture() {
                return texture;
            }
        };
    }
}

