/*
 * Decompiled with CFR 0.152.
 */
package com.yandex.runtime.network.internal;

import android.net.http.X509TrustManagerExtensions;
import android.util.Log;
import java.io.ByteArrayInputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public final class CertificateVerifier {
    public static boolean verify(byte[][] nativeCertChain) {
        X509Certificate[] certChain = CertificateVerifier.decodeChain(nativeCertChain);
        if (certChain == null) {
            return false;
        }
        X509TrustManager tm = CertificateVerifier.getTrustManager();
        if (tm == null) {
            return false;
        }
        try {
            X509TrustManagerExtensions trustManager = new X509TrustManagerExtensions(tm);
            trustManager.checkServerTrusted(certChain, "TLS", "");
        }
        catch (CertificateException e) {
            Log.e((String)"yandex.maps", (String)("Certificate is not valid: " + e.getMessage()));
            return false;
        }
        catch (IllegalArgumentException e) {
            Log.e((String)"yandex.maps", (String)("IllegalArgumentException: " + e.getMessage()));
            return false;
        }
        return true;
    }

    private static X509Certificate[] decodeChain(byte[][] nativeCertChain) {
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            X509Certificate[] certChain = new X509Certificate[nativeCertChain.length];
            for (int i = 0; i < nativeCertChain.length; ++i) {
                certChain[i] = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(nativeCertChain[i]));
            }
            return certChain;
        }
        catch (CertificateException e) {
            Log.e((String)"yandex.maps", (String)"Could not decode certificate");
            return null;
        }
    }

    private static X509TrustManager getTrustManager() {
        TrustManagerFactory factory;
        try {
            factory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            factory.init((KeyStore)null);
        }
        catch (NoSuchAlgorithmException e) {
            Log.e((String)"yandex.maps", (String)"Algorithm is not supported");
            return null;
        }
        catch (KeyStoreException e) {
            Log.e((String)"yandex.maps", (String)"Could not initialize keystore");
            return null;
        }
        TrustManager[] trustManagers = factory.getTrustManagers();
        if (trustManagers == null) {
            return null;
        }
        for (int i = 0; i < trustManagers.length; ++i) {
            if (!(trustManagers[i] instanceof X509TrustManager)) continue;
            return (X509TrustManager)trustManagers[i];
        }
        Log.e((String)"yandex.maps", (String)"X509TrustManager is missing");
        return null;
    }
}

