/*
 * Decompiled with CFR 0.152.
 */
package com.yandex.runtime.sensors.internal;

import android.hardware.SensorEvent;
import com.yandex.runtime.NativeObject;
import com.yandex.runtime.sensors.internal.SensorDataConsumer;
import com.yandex.runtime.sensors.internal.SensorSubscription;
import com.yandex.runtime.sensors.internal.TimeHelpers;

public class AccelerometerSubscription
implements SensorDataConsumer {
    private NativeObject nativeObject;
    private SensorSubscription sensorSubscription;

    public AccelerometerSubscription(NativeObject nativeObject, int sensorDelay) {
        this.nativeObject = nativeObject;
        this.sensorSubscription = new SensorSubscription(this, 1, sensorDelay);
    }

    @Override
    public void consume(SensorEvent event) {
        long absTimestamp = TimeHelpers.eventNanosToTimestampMills(event.timestamp);
        long relTimestamp = TimeHelpers.eventNanosToMills(event.timestamp);
        AccelerometerSubscription.accelerationChanged(this.nativeObject, event.values[0], event.values[1], event.values[2], event.accuracy, absTimestamp, relTimestamp);
    }

    @Override
    public void sensorUnavailable() {
        AccelerometerSubscription.accelerometerUnavailable(this.nativeObject);
    }

    public void stop() {
        this.sensorSubscription.stop();
    }

    public static boolean isAccelerometerAvailable() {
        return SensorSubscription.isSensorAvailable(1);
    }

    private static native void accelerometerUnavailable(NativeObject var0);

    private static native void accelerationChanged(NativeObject var0, float var1, float var2, float var3, int var4, long var5, long var7);
}

