/*
 * Decompiled with CFR 0.152.
 */
package com.yandex.runtime.sensors.internal;

import android.hardware.SensorEvent;
import com.yandex.runtime.NativeObject;
import com.yandex.runtime.sensors.internal.SensorDataConsumer;
import com.yandex.runtime.sensors.internal.SensorSubscription;
import com.yandex.runtime.sensors.internal.TimeHelpers;

public class BarometerSubscription
implements SensorDataConsumer {
    private NativeObject nativeObject;
    private SensorSubscription sensorSubscription;

    public BarometerSubscription(NativeObject nativeObject, int sensorDelay) {
        this.nativeObject = nativeObject;
        this.sensorSubscription = new SensorSubscription(this, 6, sensorDelay);
    }

    @Override
    public void consume(SensorEvent event) {
        long absTimestamp = TimeHelpers.eventNanosToTimestampMills(event.timestamp);
        long relTimestamp = TimeHelpers.eventNanosToMills(event.timestamp);
        BarometerSubscription.pressureChanged(this.nativeObject, event.values[0], event.accuracy, absTimestamp, relTimestamp);
    }

    @Override
    public void sensorUnavailable() {
        BarometerSubscription.barometerUnavailable(this.nativeObject);
    }

    public void stop() {
        this.sensorSubscription.stop();
    }

    public static boolean isBarometerAvailable() {
        return SensorSubscription.isSensorAvailable(6);
    }

    private static native void barometerUnavailable(NativeObject var0);

    private static native void pressureChanged(NativeObject var0, float var1, int var2, long var3, long var5);
}

