/*
 * Decompiled with CFR 0.152.
 */
package com.yandex.runtime.sensors.internal;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.le.BluetoothLeScanner;
import android.bluetooth.le.ScanCallback;
import android.bluetooth.le.ScanResult;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.PackageInfo;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import com.yandex.runtime.NativeObject;
import com.yandex.runtime.Runtime;
import java.util.List;

public class BleSubscription {
    private static final String TAG = BleSubscription.class.getCanonicalName();
    private static final String PERMISSION_BLUETOOTH = "android.permission.BLUETOOTH";
    private static final String PERMISSION_BLUETOOTH_ADMIN = "android.permission.BLUETOOTH_ADMIN";
    private static final int SCAN_RETRY_TIMEOUT = 1000;
    private NativeObject nativeObject_;
    private BluetoothAdapter adapter_;
    private BroadcastReceiver receiver_;
    private Object scanCallback_;

    public BleSubscription(NativeObject nativeObject) {
        this.nativeObject_ = nativeObject;
        this.adapter_ = BleSubscription.getBluetoothAdapter();
        this.receiver_ = this.getBluetoothStateReceiver();
        this.start();
    }

    private BroadcastReceiver getBluetoothStateReceiver() {
        BroadcastReceiver receiver = new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                if (BleSubscription.this.adapter_ != null && BleSubscription.this.adapter_.isEnabled()) {
                    BleSubscription.this.startScan();
                } else {
                    BleSubscription.this.stopScan();
                }
            }
        };
        return receiver;
    }

    public void start() {
        Handler handler = new Handler(Looper.getMainLooper());
        handler.post(new Runnable(){

            @Override
            public void run() {
                Runtime.getApplicationContext().registerReceiver(BleSubscription.this.receiver_, new IntentFilter("android.bluetooth.adapter.action.STATE_CHANGED"));
                if (BleSubscription.this.adapter_ == null) {
                    BleSubscription.this.setScanFailed();
                    return;
                }
                if (!BleSubscription.this.adapter_.isEnabled()) {
                    Log.w((String)TAG, (String)"Not starting BLE scan yet. Waiting until bluetooth is switched on");
                    return;
                }
                BleSubscription.this.startScan();
            }
        });
    }

    public void stop() {
        Handler handler = new Handler(Looper.getMainLooper());
        handler.post(new Runnable(){

            @Override
            public void run() {
                Runtime.getApplicationContext().unregisterReceiver(BleSubscription.this.receiver_);
                BleSubscription.this.stopScan();
            }
        });
    }

    public static boolean checkPermissions() {
        try {
            boolean hasBluetoothPerm = false;
            boolean hasBluetoothAdminPerm = false;
            Context context = Runtime.getApplicationContext();
            PackageInfo info = context.getPackageManager().getPackageInfo(context.getPackageName(), 4096);
            if (info.requestedPermissions != null && info.requestedPermissionsFlags != null) {
                for (int i = 0; i < info.requestedPermissions.length; ++i) {
                    boolean granted;
                    String perm = info.requestedPermissions[i];
                    boolean bl = granted = (info.requestedPermissionsFlags[i] & 2) != 0;
                    if (perm.equals(PERMISSION_BLUETOOTH) && granted) {
                        hasBluetoothPerm = true;
                    }
                    if (!perm.equals(PERMISSION_BLUETOOTH_ADMIN) || !granted) continue;
                    hasBluetoothAdminPerm = true;
                }
            }
            return hasBluetoothPerm && hasBluetoothAdminPerm;
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"Exception of calling getPackageInfo", (Throwable)e);
            return false;
        }
    }

    public static boolean isBleScanAvailable() {
        return BleSubscription.getBluetoothAdapter() != null && BleSubscription.checkPermissions();
    }

    private static BluetoothAdapter getBluetoothAdapter() {
        try {
            return BluetoothAdapter.getDefaultAdapter();
        }
        catch (SecurityException e) {
            Log.e((String)TAG, (String)"SecurityException of calling getBluetoothAdapter", (Throwable)e);
            return null;
        }
    }

    private static boolean useNewScanApi() {
        return false;
    }

    private void startScan() {
        if (this.adapter_ == null) {
            Log.e((String)TAG, (String)"BLE scan is not available");
            return;
        }
        if (this.scanCallback_ != null) {
            return;
        }
        boolean newScanApi = BleSubscription.useNewScanApi();
        this.scanCallback_ = newScanApi ? new ScanCallback(){

            public void onBatchScanResults(List<ScanResult> results) {
                for (ScanResult result : results) {
                    BleSubscription.scanResultAvailable(BleSubscription.this.nativeObject_, result.getDevice().getAddress(), result.getRssi(), result.getScanRecord().getBytes());
                }
            }

            public void onScanFailed(int errorCode) {
                switch (errorCode) {
                    case 1: 
                    case 3: {
                        BleSubscription.this.retryScan();
                        break;
                    }
                    default: {
                        BleSubscription.this.setScanFailed();
                    }
                }
            }

            public void onScanResult(int callbackType, ScanResult result) {
                BleSubscription.scanResultAvailable(BleSubscription.this.nativeObject_, result.getDevice().getAddress(), result.getRssi(), result.getScanRecord().getBytes());
            }
        } : new BluetoothAdapter.LeScanCallback(){

            public void onLeScan(BluetoothDevice device, int rssi, byte[] scanRecord) {
                BleSubscription.scanResultAvailable(BleSubscription.this.nativeObject_, device.getAddress(), rssi, scanRecord);
            }
        };
        Log.i((String)TAG, (String)"Starting BLE scan");
        try {
            if (newScanApi) {
                BluetoothLeScanner scanner = this.adapter_.getBluetoothLeScanner();
                if (scanner != null) {
                    scanner.startScan((ScanCallback)this.scanCallback_);
                } else {
                    this.scanCallback_ = null;
                }
            } else if (!this.adapter_.startLeScan((BluetoothAdapter.LeScanCallback)this.scanCallback_)) {
                this.scanCallback_ = null;
            }
        }
        catch (SecurityException e) {
            Log.e((String)TAG, (String)"SecurityException of calling startScan", (Throwable)e);
            this.setScanFailed();
        }
    }

    private void stopScan() {
        if (this.adapter_ == null) {
            Log.e((String)TAG, (String)"BLE scan is not available");
            return;
        }
        if (this.scanCallback_ == null) {
            return;
        }
        Log.i((String)TAG, (String)"Stopping BLE scan");
        if (BleSubscription.useNewScanApi()) {
            BluetoothLeScanner scanner = this.adapter_.getBluetoothLeScanner();
            if (scanner != null) {
                scanner.stopScan((ScanCallback)this.scanCallback_);
            }
        } else {
            this.adapter_.stopLeScan((BluetoothAdapter.LeScanCallback)this.scanCallback_);
        }
        this.scanCallback_ = null;
    }

    private void retryScan() {
        this.scanCallback_ = null;
        Handler handler = new Handler(Looper.getMainLooper());
        handler.postDelayed(new Runnable(){

            @Override
            public void run() {
                if (!BleSubscription.this.adapter_.isEnabled()) {
                    Log.w((String)TAG, (String)"Not starting BLE scan yet. Waiting until bluetooth is switched on");
                    return;
                }
                BleSubscription.this.startScan();
            }
        }, 1000L);
    }

    private void setScanFailed() {
        this.adapter_ = null;
        this.scanCallback_ = null;
        BleSubscription.scanFailed(this.nativeObject_);
    }

    private static native void scanResultAvailable(NativeObject var0, String var1, int var2, byte[] var3);

    private static native void scanFailed(NativeObject var0);
}

