/*
 * Decompiled with CFR 0.152.
 */
package com.yandex.runtime.sensors.internal;

import android.hardware.GeomagneticField;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.location.Location;
import android.location.LocationManager;
import android.os.Handler;
import android.os.Looper;
import android.os.SystemClock;
import android.util.Log;
import com.yandex.runtime.NativeObject;
import com.yandex.runtime.Runtime;

public class CompassHeadingSubscription
implements SensorEventListener {
    private static final String LOG_TAG = CompassHeadingSubscription.class.getCanonicalName();
    private static final boolean compassAvailable = CompassHeadingSubscription.checkCompassAvailable();
    private NativeObject nativeObject;
    private SensorManager manager;
    private final long locationThrottleTime = 1000000000L;
    private Location lastKnownLocation;
    private float[] rMatrix = new float[9];
    private float[] gravityData = new float[3];
    private float[] magneticData = new float[3];

    public CompassHeadingSubscription(NativeObject nativeObject) {
        this.nativeObject = nativeObject;
        this.manager = CompassHeadingSubscription.getSensorManager();
        Handler handler = new Handler(Looper.getMainLooper());
        handler.post(new Runnable(){

            @Override
            public void run() {
                CompassHeadingSubscription.this.start();
            }
        });
    }

    private void start() {
        Sensor rotationSensor = this.manager.getDefaultSensor(11);
        if (rotationSensor != null) {
            this.manager.registerListener((SensorEventListener)this, rotationSensor, 2);
            return;
        }
        Sensor accelerometerSensor = this.manager.getDefaultSensor(1);
        Sensor magneticSensor = this.manager.getDefaultSensor(2);
        if (accelerometerSensor != null && magneticSensor != null) {
            this.manager.registerListener((SensorEventListener)this, accelerometerSensor, 3);
            this.manager.registerListener((SensorEventListener)this, magneticSensor, 3);
        } else {
            CompassHeadingSubscription.headingUnavailable(this.nativeObject);
        }
    }

    public void stop() {
        Handler handler = new Handler(Looper.getMainLooper());
        final CompassHeadingSubscription self = this;
        handler.post(new Runnable(){

            @Override
            public void run() {
                CompassHeadingSubscription.this.manager.unregisterListener((SensorEventListener)self);
            }
        });
    }

    public void onAccuracyChanged(Sensor sensor, int accuracy) {
    }

    public void onSensorChanged(SensorEvent event) {
        switch (event.sensor.getType()) {
            case 1: {
                System.arraycopy(event.values, 0, this.gravityData, 0, this.gravityData.length);
                this.processEventFromMagnetometerAndAccelerometer(event);
                break;
            }
            case 2: {
                System.arraycopy(event.values, 0, this.magneticData, 0, this.magneticData.length);
                this.processEventFromMagnetometerAndAccelerometer(event);
                break;
            }
            case 11: {
                this.processEventFromRotationVector(event);
                break;
            }
            default: {
                return;
            }
        }
    }

    public static boolean isCompassAvailable() {
        return compassAvailable;
    }

    private void processEventFromMagnetometerAndAccelerometer(SensorEvent event) {
        if (!SensorManager.getRotationMatrix((float[])this.rMatrix, null, (float[])this.gravityData, (float[])this.magneticData)) {
            return;
        }
        this.sendHeading(event.accuracy);
    }

    private void processEventFromRotationVector(SensorEvent event) {
        int maxRotationDataSize = 4;
        float[] rotationData = new float[4];
        int maxCopySize = event.values.length > 4 ? 4 : event.values.length;
        System.arraycopy(event.values, 0, rotationData, 0, maxCopySize);
        SensorManager.getRotationMatrixFromVector((float[])this.rMatrix, (float[])rotationData);
        this.sendHeading(event.accuracy);
    }

    private void sendHeading(int accuracy) {
        float[] orientation = new float[3];
        SensorManager.getOrientation((float[])this.rMatrix, (float[])orientation);
        float magneticNorth = this.normalizeAngle((float)Math.toDegrees(orientation[0]));
        float trueNorth = this.normalizeAngle(magneticNorth + this.getDeclination());
        CompassHeadingSubscription.headingChanged(this.nativeObject, magneticNorth, trueNorth, accuracy);
    }

    private float normalizeAngle(float degree) {
        return Float.isNaN(degree) || Float.isInfinite(degree) ? 0.0f : (degree + 360.0f) % 360.0f;
    }

    private float getDeclination() {
        long now = SystemClock.elapsedRealtimeNanos();
        if (this.lastKnownLocation == null || now - this.lastKnownLocation.getElapsedRealtimeNanos() > 1000000000L) {
            this.lastKnownLocation = CompassHeadingSubscription.getLastKnownLocation();
        }
        if (this.lastKnownLocation == null) {
            return 0.0f;
        }
        return new GeomagneticField((float)this.lastKnownLocation.getLatitude(), (float)this.lastKnownLocation.getLongitude(), this.lastKnownLocation.hasAltitude() ? (float)this.lastKnownLocation.getAltitude() : 0.0f, this.lastKnownLocation.getTime()).getDeclination();
    }

    private static boolean checkCompassAvailable() {
        SensorManager manager = CompassHeadingSubscription.getSensorManager();
        return manager.getDefaultSensor(11) != null || manager.getDefaultSensor(1) != null && manager.getDefaultSensor(2) != null;
    }

    private static SensorManager getSensorManager() {
        SensorManager manager = (SensorManager)Runtime.getApplicationContext().getSystemService("sensor");
        if (manager == null) {
            throw new RuntimeException("Can't get SensorManager.");
        }
        return manager;
    }

    private static Location getLastKnownLocation() {
        LocationManager manager = (LocationManager)Runtime.getApplicationContext().getSystemService("location");
        if (manager == null) {
            throw new RuntimeException("Can't get LocationManager. Missed permission?");
        }
        try {
            return manager.getLastKnownLocation("gps");
        }
        catch (SecurityException e) {
            Log.e((String)LOG_TAG, (String)("failed to get last known location: " + e.toString()));
            return null;
        }
    }

    private static native void headingChanged(NativeObject var0, float var1, float var2, float var3);

    private static native void headingUnavailable(NativeObject var0);
}

