/*
 * Decompiled with CFR 0.152.
 */
package com.yandex.runtime.sensors.internal;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.location.Location;
import android.os.Build;
import android.os.Bundle;
import android.os.Looper;
import android.util.Log;
import androidx.core.content.ContextCompat;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GoogleApiAvailability;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.location.FusedLocationProviderClient;
import com.google.android.gms.location.LocationCallback;
import com.google.android.gms.location.LocationRequest;
import com.google.android.gms.location.LocationResult;
import com.google.android.gms.location.LocationServices;
import com.yandex.runtime.NativeObject;
import com.yandex.runtime.Runtime;

public class FusedLocationSubscription
extends LocationCallback
implements GoogleApiClient.ConnectionCallbacks,
GoogleApiClient.OnConnectionFailedListener {
    private GoogleApiClient googleApiClient;
    private LocationRequest locationRequest;
    private FusedLocationProviderClient fusedLocationProviderClient = null;
    NativeObject nativeObject;
    private static final String LOG_TAG = FusedLocationSubscription.class.getCanonicalName();

    public FusedLocationSubscription(float movementThreshold, int timeInterval, NativeObject nativeObject) {
        this.nativeObject = nativeObject;
        this.googleApiClient = new GoogleApiClient.Builder(Runtime.getApplicationContext()).addApi(LocationServices.API).addConnectionCallbacks((GoogleApiClient.ConnectionCallbacks)this).addOnConnectionFailedListener((GoogleApiClient.OnConnectionFailedListener)this).build();
        this.locationRequest = LocationRequest.create().setSmallestDisplacement(movementThreshold).setInterval((long)timeInterval).setPriority(100);
        this.googleApiClient.connect();
    }

    public void onConnected(Bundle bundle) {
        if (Build.VERSION.SDK_INT >= 23 && ContextCompat.checkSelfPermission((Context)Runtime.getApplicationContext(), (String)"android.permission.ACCESS_FINE_LOCATION") != 0) {
            Log.e((String)LOG_TAG, (String)"No ACCESS_FINE_LOCATION permission, can't start FusedProvider");
            return;
        }
        this.fusedLocationProviderClient = LocationServices.getFusedLocationProviderClient((Context)Runtime.getApplicationContext());
        this.fusedLocationProviderClient.requestLocationUpdates(this.locationRequest, (LocationCallback)this, Looper.getMainLooper());
    }

    public void onConnectionSuspended(int cause) {
        Log.w((String)LOG_TAG, (String)"Connection suspended!");
        FusedLocationSubscription.statusChanged(this.nativeObject, false);
    }

    public void onConnectionFailed(ConnectionResult connectionResult) {
        Log.w((String)LOG_TAG, (String)"Connection Failed!");
        FusedLocationSubscription.statusChanged(this.nativeObject, false);
    }

    public void onLocationResult(LocationResult locationResult) {
        FusedLocationSubscription.locationChanged(this.nativeObject, locationResult.getLastLocation());
    }

    public void stop() {
        FusedLocationSubscription.statusChanged(this.nativeObject, false);
        if (this.fusedLocationProviderClient != null) {
            this.fusedLocationProviderClient.removeLocationUpdates((LocationCallback)this);
        }
        this.googleApiClient.disconnect();
    }

    private static long getPlayServicesVersion() {
        PackageInfo packageInfo;
        try {
            packageInfo = Runtime.getApplicationContext().getPackageManager().getPackageInfo("com.google.android.gms", 0);
        }
        catch (PackageManager.NameNotFoundException e) {
            Log.w((String)LOG_TAG, (String)"Google Play Services Package not found!", (Throwable)e);
            return 0L;
        }
        return packageInfo.versionCode;
    }

    public static final boolean fusedLocationProviderAvailable() {
        if (GoogleApiAvailability.getInstance().isGooglePlayServicesAvailable(Runtime.getApplicationContext()) != 0) {
            return false;
        }
        return FusedLocationSubscription.getPlayServicesVersion() >= 11600000L;
    }

    static native void locationChanged(NativeObject var0, Location var1);

    static native void statusChanged(NativeObject var0, boolean var1);
}

