/*
 * Decompiled with CFR 0.152.
 */
package com.yandex.runtime.sensors.internal;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.location.Location;
import android.location.LocationListener;
import android.location.LocationManager;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.SystemClock;
import android.util.Log;
import com.yandex.runtime.NativeObject;
import com.yandex.runtime.Runtime;

public class LocationSubscription
implements LocationListener {
    private static final String LOG_TAG = LocationSubscription.class.getCanonicalName();
    private final Provider provider;
    private final NativeObject nativeLocationSubscription;
    private final LocationManager manager;
    private final float movementThreshold;
    private final long reportInterval;
    private final BroadcastReceiver gpsStateReceiver;

    public LocationSubscription(Provider provider, long reportInterval, float movementThreshold, NativeObject nativeLocationSubscription) {
        this.provider = provider;
        this.reportInterval = reportInterval;
        this.movementThreshold = movementThreshold;
        this.nativeLocationSubscription = nativeLocationSubscription;
        this.gpsStateReceiver = !LocationSubscription.isLocationListenerStatusChangedSupported() ? this.getGpsStateReceiver() : null;
        this.manager = (LocationManager)Runtime.getApplicationContext().getSystemService("location");
        if (this.manager == null) {
            throw new RuntimeException("Can't get LocationManager. Missed permission?");
        }
        Handler handler = new Handler(Looper.getMainLooper());
        handler.post(new Runnable(){

            @Override
            public void run() {
                if (!LocationSubscription.isLocationListenerStatusChangedSupported()) {
                    Runtime.getApplicationContext().registerReceiver(LocationSubscription.this.gpsStateReceiver, new IntentFilter("android.location.PROVIDERS_CHANGED"));
                }
                LocationSubscription.this.start();
            }
        });
    }

    private BroadcastReceiver getGpsStateReceiver() {
        return new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                if (LocationSubscription.this.manager == null) {
                    return;
                }
                LocationSubscription.statusChanged(LocationSubscription.this.nativeLocationSubscription, LocationSubscription.this.manager.isProviderEnabled("gps"));
            }
        };
    }

    private void start() {
        try {
            this.manager.requestLocationUpdates(this.provider.toString(), this.reportInterval, this.movementThreshold, (LocationListener)this);
            return;
        }
        catch (SecurityException e) {
            Log.e((String)LOG_TAG, (String)"SecurityException of calling startProvider", (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            Log.e((String)LOG_TAG, (String)"IllegalArgumentException of calling startProvider", (Throwable)e);
        }
        catch (RuntimeException e) {
            Log.e((String)LOG_TAG, (String)"RuntimeException of calling startProvider", (Throwable)e);
        }
        LocationSubscription.statusChanged(this.nativeLocationSubscription, false);
    }

    public void stop() {
        Handler handler = new Handler(Looper.getMainLooper());
        handler.post(new Runnable(){

            @Override
            public void run() {
                if (!LocationSubscription.isLocationListenerStatusChangedSupported()) {
                    Runtime.getApplicationContext().unregisterReceiver(LocationSubscription.this.gpsStateReceiver);
                }
                LocationSubscription.this.manager.removeUpdates((LocationListener)LocationSubscription.this);
            }
        });
    }

    public void onLocationChanged(Location location) {
        LocationSubscription.locationChanged(this.nativeLocationSubscription, location);
    }

    public void onStatusChanged(String provider, int status, Bundle extras) {
        boolean isAvailable = status == 2;
        LocationSubscription.statusChanged(this.nativeLocationSubscription, isAvailable);
    }

    public void onProviderDisabled(String provider) {
        LocationSubscription.statusChanged(this.nativeLocationSubscription, false);
    }

    public void onProviderEnabled(String provider) {
    }

    public static long relativeTimeDelta(Location location) {
        if (location.getElapsedRealtimeNanos() > 0L) {
            int NANOS_IN_MS = 1000000;
            return SystemClock.elapsedRealtime() - location.getElapsedRealtimeNanos() / 1000000L;
        }
        return 0L;
    }

    public static boolean isLocationListenerStatusChangedSupported() {
        return Build.VERSION.SDK_INT < 29;
    }

    static native void locationChanged(NativeObject var0, Location var1);

    static native void statusChanged(NativeObject var0, boolean var1);

    public static enum Provider {
        GPS("gps"),
        NETWORK("network"),
        PASSIVE("passive");

        private String value;

        private Provider(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

