/*
 * Decompiled with CFR 0.152.
 */
package com.yandex.runtime.sensors.internal;

import android.hardware.SensorEvent;
import com.yandex.runtime.NativeObject;
import com.yandex.runtime.sensors.internal.SensorDataConsumer;
import com.yandex.runtime.sensors.internal.SensorSubscription;
import com.yandex.runtime.sensors.internal.TimeHelpers;

public class MagnetometerSubscription
implements SensorDataConsumer {
    private NativeObject nativeObject;
    private SensorSubscription sensorSubscription;

    public MagnetometerSubscription(NativeObject nativeObject, int sensorDelay) {
        this.nativeObject = nativeObject;
        this.sensorSubscription = new SensorSubscription(this, 2, sensorDelay);
    }

    @Override
    public void consume(SensorEvent event) {
        long absTimestamp = TimeHelpers.eventNanosToTimestampMills(event.timestamp);
        long relTimestamp = TimeHelpers.eventNanosToMills(event.timestamp);
        MagnetometerSubscription.magnetometerChanged(this.nativeObject, event.values[0], event.values[1], event.values[2], event.accuracy, absTimestamp, relTimestamp);
    }

    @Override
    public void sensorUnavailable() {
        MagnetometerSubscription.magnetometerUnavailable(this.nativeObject);
    }

    public void stop() {
        this.sensorSubscription.stop();
    }

    public static boolean isMagnetometerAvailable() {
        return SensorSubscription.isSensorAvailable(2);
    }

    private static native void magnetometerUnavailable(NativeObject var0);

    private static native void magnetometerChanged(NativeObject var0, float var1, float var2, float var3, int var4, long var5, long var7);
}

