/*
 * Decompiled with CFR 0.152.
 */
package com.yandex.runtime.sensors.internal;

import android.hardware.SensorEvent;
import com.yandex.runtime.NativeObject;
import com.yandex.runtime.sensors.internal.SensorDataConsumer;
import com.yandex.runtime.sensors.internal.SensorSubscription;
import com.yandex.runtime.sensors.internal.TimeHelpers;

public class RotationVectorSubscription
implements SensorDataConsumer {
    private NativeObject nativeObject;
    private SensorSubscription sensorSubscription;

    public RotationVectorSubscription(NativeObject nativeObject, int sensorDelay) {
        this.nativeObject = nativeObject;
        this.sensorSubscription = new SensorSubscription(this, 11, sensorDelay);
    }

    @Override
    public void consume(SensorEvent event) {
        long timestamp = TimeHelpers.eventNanosToTimestampMills(event.timestamp);
        if (event.values.length == 3) {
            RotationVectorSubscription.rotationVectorChanged(this.nativeObject, event.values[0], event.values[1], event.values[2], event.accuracy, timestamp);
        } else {
            RotationVectorSubscription.rotationVectorChangedScalar(this.nativeObject, event.values[0], event.values[1], event.values[2], event.values[3], event.accuracy, timestamp);
        }
    }

    @Override
    public void sensorUnavailable() {
        RotationVectorSubscription.rotationVectorUnavailable(this.nativeObject);
    }

    public void stop() {
        this.sensorSubscription.stop();
    }

    public static boolean isRotationVectorAvailable() {
        return SensorSubscription.isSensorAvailable(11);
    }

    private static native void rotationVectorUnavailable(NativeObject var0);

    private static native void rotationVectorChanged(NativeObject var0, float var1, float var2, float var3, int var4, long var5);

    private static native void rotationVectorChangedScalar(NativeObject var0, float var1, float var2, float var3, float var4, int var5, long var6);
}

