/*
 * Decompiled with CFR 0.152.
 */
package com.yandex.runtime.sensors.internal;

import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.os.Handler;
import android.os.Looper;
import com.yandex.runtime.Runtime;
import com.yandex.runtime.sensors.internal.SensorDataConsumer;

public class SensorSubscription
implements SensorEventListener {
    private SensorManager manager;
    private int sensorDelay;
    private int sensorType;
    private SensorDataConsumer dataConsumer;
    private static final int nanoSecsInMilli = 1000000;
    private long prevPublishedEventTime = 0L;

    public SensorSubscription(SensorDataConsumer dataConsumer, int sensorType, int sensorDelay) {
        this.sensorDelay = sensorDelay;
        this.sensorType = sensorType;
        this.dataConsumer = dataConsumer;
        try {
            this.manager = SensorSubscription.getSensorManager();
        }
        catch (RuntimeException e) {
            this.stop();
            this.dataConsumer.sensorUnavailable();
        }
        Handler handler = new Handler(Looper.getMainLooper());
        handler.post(new Runnable(){

            @Override
            public void run() {
                SensorSubscription.this.start();
            }
        });
    }

    private void start() {
        Sensor sensor = this.manager.getDefaultSensor(this.sensorType);
        if (sensor != null) {
            this.manager.registerListener((SensorEventListener)this, sensor, this.sensorDelay * 1000);
        } else {
            this.stop();
            this.dataConsumer.sensorUnavailable();
        }
    }

    public void stop() {
        Handler handler = new Handler(Looper.getMainLooper());
        handler.post(new Runnable(){

            @Override
            public void run() {
                SensorSubscription.this.manager.unregisterListener((SensorEventListener)SensorSubscription.this);
            }
        });
    }

    public void onAccuracyChanged(Sensor sensor, int accuracy) {
    }

    public void onSensorChanged(SensorEvent event) {
        if ((event.timestamp - this.prevPublishedEventTime) / 1000000L >= (long)this.sensorDelay) {
            this.prevPublishedEventTime = event.timestamp;
            this.dataConsumer.consume(event);
        }
    }

    public static boolean isSensorAvailable(int sensorType) {
        try {
            SensorManager manager = SensorSubscription.getSensorManager();
            return manager.getDefaultSensor(sensorType) != null;
        }
        catch (RuntimeException e) {
            return false;
        }
    }

    private static SensorManager getSensorManager() {
        SensorManager manager = (SensorManager)Runtime.getApplicationContext().getSystemService("sensor");
        if (manager == null) {
            throw new RuntimeException("Can't get SensorManager.");
        }
        return manager;
    }
}

