/*
 * Decompiled with CFR 0.152.
 */
package com.yandex.runtime.sensors.internal.telephony;

import android.content.Context;
import android.telephony.TelephonyManager;
import com.yandex.runtime.Runtime;
import com.yandex.runtime.bindings.Archive;
import com.yandex.runtime.bindings.Serializable;

public class OperatorInfo
implements Serializable {
    public static final int MCC_LENGTH = 3;
    private String mcc;
    private String mnc;

    public OperatorInfo(String mcc, String mnc) {
        this.mcc = mcc;
        this.mnc = mnc;
    }

    @Override
    public void serialize(Archive archive) {
        this.mcc = archive.add(this.mcc, false);
        this.mnc = archive.add(this.mnc, false);
    }

    public static OperatorInfo getOperatorInfo() {
        String sim;
        Context context = Runtime.getApplicationContext();
        TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
        OperatorInfo operatorInfo = null;
        if (telephonyManager.getSimState() == 5 && (sim = telephonyManager.getSimOperator()) != null && sim.length() >= 3) {
            String mcc = sim.substring(0, 3);
            String mnc = sim.substring(3);
            operatorInfo = new OperatorInfo(mcc, mnc);
        }
        return operatorInfo;
    }
}

