/*
 * Decompiled with CFR 0.152.
 */
package com.yandex.runtime.sensors.internal.telephony;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.telephony.PhoneStateListener;
import android.telephony.SignalStrength;
import android.telephony.TelephonyManager;
import com.yandex.runtime.NativeObject;
import com.yandex.runtime.Runtime;
import com.yandex.runtime.logging.Logger;
import com.yandex.runtime.sensors.internal.telephony.GsmCellInfo;
import com.yandex.runtime.sensors.internal.telephony.TelephonyUtils;
import java.util.List;

public class TelephonySubscription {
    private NativeObject nativeObject;
    private Context context = Runtime.getApplicationContext();
    private TelephonyManager telephonyManager = (TelephonyManager)this.context.getSystemService("phone");
    private SignalStrengthListener signalStrengthListener;
    private static final String TAG = TelephonySubscription.class.getCanonicalName();

    public TelephonySubscription() {
        this.nativeObject = TelephonySubscription.createPromise();
        this.requestTelephonyNetworkInfo();
    }

    public void cancel() {
        Handler handler = new Handler(Looper.getMainLooper());
        handler.post(new Runnable(){

            @Override
            public void run() {
                TelephonySubscription.this.unsubscribe();
            }
        });
    }

    private void unsubscribe() {
        try {
            this.telephonyManager.listen((PhoneStateListener)this.signalStrengthListener, 0);
        }
        catch (SecurityException e) {
            Logger.error("exception while stopping signal strengths listen: " + e.getMessage());
            return;
        }
    }

    private void requestTelephonyNetworkInfo() {
        Handler handler = new Handler(Looper.getMainLooper());
        handler.post(new Runnable(){

            @Override
            public void run() {
                TelephonySubscription.this.signalStrengthListener = new SignalStrengthListener();
                try {
                    TelephonySubscription.this.telephonyManager.listen((PhoneStateListener)TelephonySubscription.this.signalStrengthListener, 256);
                }
                catch (SecurityException e) {
                    Logger.error("exception while accessing signal strengths: " + e.getMessage());
                    return;
                }
            }
        });
    }

    native void telephonyNetworkInfoAvailable(GsmCellInfo var1);

    static native NativeObject createPromise();

    private class SignalStrengthListener
    extends PhoneStateListener {
        private boolean signalReceived = false;

        private SignalStrengthListener() {
        }

        public void onSignalStrengthsChanged(SignalStrength signalStrength) {
            if (this.signalReceived) {
                return;
            }
            this.signalReceived = true;
            TelephonySubscription.this.unsubscribe();
            GsmCellInfo gsmCellInfo = null;
            try {
                List<GsmCellInfo> cellInfoGsmList = TelephonyUtils.getAllCellInfo(TelephonySubscription.this.telephonyManager);
                if (!cellInfoGsmList.isEmpty()) {
                    gsmCellInfo = cellInfoGsmList.get(0);
                }
                TelephonySubscription.this.telephonyNetworkInfoAvailable(gsmCellInfo);
            }
            catch (Exception e) {
                Logger.error("exception while handling signal strengths changed: " + e.getMessage());
                return;
            }
        }
    }
}

