/*
 * Decompiled with CFR 0.152.
 */
package com.yandex.runtime.sensors.internal.telephony;

import android.telephony.CellIdentityGsm;
import android.telephony.CellInfo;
import android.telephony.CellInfoGsm;
import android.telephony.TelephonyManager;
import com.yandex.runtime.sensors.internal.telephony.GsmCellInfo;
import java.util.ArrayList;
import java.util.List;

public class TelephonyUtils {
    private static final int UNKNOWN_VALUE = 0;

    public static boolean isKnown(int value) {
        return value > 0;
    }

    public static GsmCellInfo convert(CellInfoGsm cellInfoGsm) {
        CellIdentityGsm cellIdentityGsm = cellInfoGsm.getCellIdentity();
        if (TelephonyUtils.isKnown(cellIdentityGsm.getCid()) && TelephonyUtils.isKnown(cellIdentityGsm.getLac())) {
            return new GsmCellInfo(cellIdentityGsm.getCid(), cellIdentityGsm.getLac(), cellInfoGsm.getCellSignalStrength().getDbm());
        }
        return null;
    }

    public static List<GsmCellInfo> getAllCellInfo(TelephonyManager telephonyManager) {
        ArrayList<GsmCellInfo> cellInfoGsmList = new ArrayList<GsmCellInfo>();
        List cellInfoList = telephonyManager.getAllCellInfo();
        if (cellInfoList != null) {
            for (CellInfo cellInfo : cellInfoList) {
                if (!(cellInfo instanceof CellInfoGsm)) continue;
                cellInfoGsmList.add(TelephonyUtils.convert((CellInfoGsm)cellInfo));
            }
        }
        return cellInfoGsmList;
    }
}

