/*
 * Decompiled with CFR 0.152.
 */
package com.yandex.runtime.sensors.internal.wifi;

import android.net.wifi.ScanResult;
import android.net.wifi.WifiInfo;
import com.yandex.runtime.bindings.Archive;
import com.yandex.runtime.bindings.Serializable;

public class WifiPointInfo
implements Serializable {
    private String bssid;
    private String ssid;
    private int level;

    public WifiPointInfo(ScanResult scanResult) {
        this.bssid = scanResult.BSSID;
        this.ssid = scanResult.SSID;
        this.level = scanResult.level;
    }

    public WifiPointInfo(WifiInfo wifiInfo) {
        this.bssid = wifiInfo.getBSSID();
        this.ssid = wifiInfo.getSSID();
        if (this.ssid.startsWith("\"") && this.ssid.endsWith("\"")) {
            this.ssid = this.ssid.substring(1, this.ssid.length() - 1);
        }
        this.level = wifiInfo.getRssi();
    }

    @Override
    public void serialize(Archive archive) {
        this.bssid = archive.add(this.bssid, false);
        this.ssid = archive.add(this.ssid, false);
        this.level = archive.add(this.level);
    }
}

