/*
 * Decompiled with CFR 0.152.
 */
package com.yandex.runtime.sensors.internal.wifi;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.wifi.ScanResult;
import android.net.wifi.WifiManager;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import com.yandex.runtime.Runtime;
import com.yandex.runtime.sensors.internal.wifi.WifiPointInfo;
import java.util.ArrayList;
import java.util.List;

public class WifiSubscription
extends BroadcastReceiver {
    private final String TAG = ((Object)((Object)this)).getClass().getCanonicalName();
    private long nativePromise;
    private WifiManager wifiManager = (WifiManager)Runtime.getApplicationContext().getSystemService("wifi");
    private boolean isRegistered = false;

    public void startScan(long promise) {
        Handler handler = new Handler(Looper.getMainLooper());
        class StartTask
        implements Runnable {
            long promise;

            StartTask(long nativeObject) {
                this.promise = nativeObject;
            }

            @Override
            public void run() {
                WifiSubscription.this.startScanImpl(this.promise);
            }
        }
        handler.post((Runnable)new StartTask(promise));
    }

    private void startScanImpl(long promise) {
        this.nativePromise = promise;
        Context context = Runtime.getApplicationContext();
        context.registerReceiver((BroadcastReceiver)this, new IntentFilter("android.net.wifi.SCAN_RESULTS"));
        this.isRegistered = true;
        if (!this.wifiManager.isWifiEnabled() || !this.wifiManager.startScan()) {
            this.unregister(context);
            ArrayList<WifiPointInfo> emptyResult = new ArrayList<WifiPointInfo>();
            WifiSubscription.scanResultsAvailable(this.nativePromise, emptyResult);
        }
    }

    public void onReceive(Context context, Intent intent) {
        this.unregister(context);
        this.getScanResultsAsync();
    }

    private void getScanResults() {
        try {
            List scanResults = this.wifiManager.getScanResults();
            if (scanResults != null) {
                ArrayList<WifiPointInfo> observedWifiPoints = new ArrayList<WifiPointInfo>(scanResults.size());
                for (ScanResult result : scanResults) {
                    observedWifiPoints.add(new WifiPointInfo(result));
                }
                WifiSubscription.scanResultsAvailable(this.nativePromise, observedWifiPoints);
            }
        }
        catch (SecurityException e) {
            Log.e((String)this.TAG, (String)("onReceive: SecurityException: " + e.toString()));
        }
    }

    protected void finalize() {
        WifiSubscription.deleteNativePromise(this.nativePromise);
    }

    public void cancel() {
        Handler handler = new Handler(Looper.getMainLooper());
        handler.post(new Runnable(){

            @Override
            public void run() {
                WifiSubscription.this.unregister(Runtime.getApplicationContext());
            }
        });
    }

    private void unregister(Context context) {
        if (this.isRegistered) {
            context.unregisterReceiver((BroadcastReceiver)this);
            this.isRegistered = false;
        }
    }

    static native void scanResultsAvailable(long var0, List<WifiPointInfo> var2);

    static native void deleteNativePromise(long var0);

    native void getScanResultsAsync();
}

