/*
 * Decompiled with CFR 0.152.
 */
package com.yandex.runtime.ui_view;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.view.View;
import com.yandex.runtime.image.ImageProvider;
import java.util.UUID;

public class ViewProvider {
    private final View view;
    private final String id;
    private final boolean cacheable;
    private Bitmap image;
    private int version;

    public ViewProvider(View view, boolean cacheable) {
        this.view = view;
        this.id = "view: " + UUID.randomUUID().toString();
        this.version = 0;
        this.cacheable = cacheable;
        this.snapshot();
    }

    public ViewProvider(View view) {
        this(view, true);
    }

    public String getId() {
        return this.id;
    }

    public boolean isCacheable() {
        return this.cacheable;
    }

    private ImageProvider getImageProvider() {
        return ImageProvider.fromBitmap(this.image, this.cacheable, this.id + "#" + String.valueOf(this.version));
    }

    public void snapshot() {
        this.view.measure(0, 0);
        this.image = Bitmap.createBitmap((int)this.view.getMeasuredWidth(), (int)this.view.getMeasuredHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(this.image);
        this.view.layout(0, 0, this.view.getMeasuredWidth(), this.view.getMeasuredHeight());
        this.view.draw(canvas);
        ++this.version;
    }
}

