/*
 * Decompiled with CFR 0.152.
 */
package com.yandex.runtime.view;

import android.content.ComponentCallbacks;
import android.content.Context;
import android.opengl.GLSurfaceView;
import android.view.Surface;
import android.view.View;
import androidx.annotation.NonNull;
import com.yandex.runtime.NativeObject;
import com.yandex.runtime.graphics.GLDebugBinding;
import com.yandex.runtime.view.PlatformView;
import com.yandex.runtime.view.internal.GLSurface;
import com.yandex.runtime.view.internal.MemoryPressureListener;
import com.yandex.runtime.view.internal.PlatformGLRenderer;
import com.yandex.runtime.view.internal.PlatformViewBinding;
import com.yandex.runtime.view.internal.RenderDelegate;

public class PlatformGLSurface
extends GLSurface
implements RenderDelegate,
PlatformView,
PlatformGLRenderer.GLContextListener {
    boolean glDebugEnabled;
    private PlatformViewBinding platformViewBinding;
    private MemoryPressureListener memoryPressureListener;
    private Context context;
    private int width;
    private int height;

    public PlatformGLSurface(Context context, boolean glDebugEnabled, GLSurfaceView.Renderer overlayRenderer) {
        super(glDebugEnabled);
        this.context = context;
        this.glDebugEnabled = glDebugEnabled;
        PlatformGLRenderer renderer = new PlatformGLRenderer(this, this, overlayRenderer);
        this.platformViewBinding = new PlatformViewBinding(renderer, 100, 100);
        this.setRenderer(renderer);
    }

    @Override
    public NativeObject getNativePlatformView() {
        return this.platformViewBinding.getNative();
    }

    @Override
    public void destroyNativePlatformView() {
        this.stopRenderThread();
        this.platformViewBinding.destroyNative();
    }

    @Override
    public void pause() {
        this.platformViewBinding.onPause();
    }

    @Override
    public void resume() {
        this.platformViewBinding.onResume();
    }

    @Override
    public void stop() {
        if (this.memoryPressureListener != null) {
            this.context.unregisterComponentCallbacks((ComponentCallbacks)this.memoryPressureListener);
            this.memoryPressureListener = null;
        }
        this.platformViewBinding.onStop();
        this.onPause();
    }

    @Override
    public void start() {
        if (this.memoryPressureListener == null) {
            this.memoryPressureListener = new MemoryPressureListener(this);
            this.context.registerComponentCallbacks((ComponentCallbacks)this.memoryPressureListener);
        }
        this.onResume();
        this.platformViewBinding.onStart(this.width, this.height);
        this.platformViewBinding.onSizeChanged(this.width, this.height);
    }

    @Override
    public View getView() {
        return null;
    }

    @Override
    public void setNoninteractive(boolean is) {
        this.platformViewBinding.setNoninteractive(is);
    }

    @Override
    public void onContextCreated() {
        if (this.glDebugEnabled) {
            GLDebugBinding.enable();
        }
    }

    @Override
    public void onMemoryWarning() {
        this.platformViewBinding.onMemoryWarning();
    }

    @Override
    public void onSurfaceAvailable(@NonNull Surface surface, int width, int height) {
        super.onSurfaceAvailable(surface, width, height);
        this.width = width;
        this.height = height;
    }

    public void requestRenderNative() {
        this.platformViewBinding.requestRenderNative();
    }
}

