/*
 * Decompiled with CFR 0.152.
 */
package com.yandex.runtime.view;

import android.content.ComponentCallbacks;
import android.content.Context;
import android.graphics.SurfaceTexture;
import android.util.DisplayMetrics;
import android.view.MotionEvent;
import android.view.View;
import android.view.WindowManager;
import com.yandex.runtime.NativeObject;
import com.yandex.runtime.graphics.GLDebugBinding;
import com.yandex.runtime.view.PlatformView;
import com.yandex.runtime.view.internal.GLTextureView;
import com.yandex.runtime.view.internal.MemoryPressureListener;
import com.yandex.runtime.view.internal.PlatformGLRenderer;
import com.yandex.runtime.view.internal.PlatformViewBinding;
import com.yandex.runtime.view.internal.RenderDelegate;

public class PlatformGLSurfaceTextureView
extends GLTextureView
implements RenderDelegate,
PlatformView,
PlatformGLRenderer.GLContextListener {
    protected Context context;
    protected boolean glDebugEnabled;
    protected PlatformGLRenderer renderer;
    protected PlatformViewBinding platformViewBinding;
    protected MemoryPressureListener memoryPressureListener;
    protected int width;
    protected int height;

    public PlatformGLSurfaceTextureView(Context context, boolean glDebugEnabled) {
        super(glDebugEnabled);
        DisplayMetrics metrics = new DisplayMetrics();
        Context applicationContext = context.getApplicationContext();
        WindowManager manager = (WindowManager)applicationContext.getSystemService("window");
        manager.getDefaultDisplay().getMetrics(metrics);
        this.init(context, metrics.widthPixels, metrics.heightPixels);
    }

    public PlatformGLSurfaceTextureView(Context context, int width, int height, boolean glDebugEnabled) {
        super(glDebugEnabled);
        this.init(context, width, height);
    }

    private void init(Context context, int width, int height) {
        this.context = context;
        this.width = width;
        this.height = height;
        this.renderer = new PlatformGLRenderer(this, this);
        this.platformViewBinding = new PlatformViewBinding(this.renderer, width, height);
    }

    public void setTexture(SurfaceTexture surfaceTexture, int width, int height) {
        this.width = width;
        this.height = height;
        this.setRenderer(surfaceTexture, width, height, this.renderer);
    }

    public void setTexture(SurfaceTexture surfaceTexture) {
        this.setTexture(surfaceTexture, this.width, this.height);
    }

    @Override
    public void onSizeChanged(int width, int height) {
        this.platformViewBinding.onSizeChanged(width, height);
        super.onSizeChanged(width, height);
    }

    public boolean onTouchEvent(MotionEvent event) {
        return this.platformViewBinding.onTouchEvent(event);
    }

    @Override
    public NativeObject getNativePlatformView() {
        return this.platformViewBinding.getNative();
    }

    @Override
    public void destroyNativePlatformView() {
        this.platformViewBinding.destroyNative();
    }

    @Override
    public void pause() {
        this.platformViewBinding.onPause();
    }

    @Override
    public void resume() {
        this.platformViewBinding.onResume();
    }

    @Override
    public void stop() {
        if (this.memoryPressureListener != null) {
            this.context.unregisterComponentCallbacks((ComponentCallbacks)this.memoryPressureListener);
            this.memoryPressureListener = null;
        }
        this.platformViewBinding.onStop();
        this.onPause();
    }

    @Override
    public void start() {
        if (this.memoryPressureListener == null) {
            this.memoryPressureListener = new MemoryPressureListener(this);
            this.context.registerComponentCallbacks((ComponentCallbacks)this.memoryPressureListener);
        }
        this.onResume();
        this.platformViewBinding.onStart(this.width, this.height);
    }

    @Override
    public View getView() {
        return null;
    }

    @Override
    public void setNoninteractive(boolean is) {
        this.platformViewBinding.setNoninteractive(is);
    }

    @Override
    public void onMemoryWarning() {
        this.platformViewBinding.onMemoryWarning();
    }

    @Override
    public void onContextCreated() {
        if (this.glDebugEnabled) {
            GLDebugBinding.enable();
        }
    }
}

